/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;

public class SnmpValue {
    private String name;
    private SnmpObjectId objectId;
    private int type;
    private String value;

    public SnmpValue(String name, int type, String value) {
        this.name = name;
        this.objectId = null;
        this.type = type;
        this.value = value;
    }

    public SnmpValue(SnmpObjectId objectId, int type, String value) {
        this.name = objectId.toString();
        this.objectId = objectId;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public SnmpObjectId getObjectId() {
        if (this.objectId == null) {
            try {
                this.objectId = SnmpObjectId.parseSnmpObjectId(this.name);
            }
            catch (SnmpObjectIdFormatException e) {
                this.objectId = new SnmpObjectId();
            }
        }
        return this.objectId;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }
}

