/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.ServerFile;
import org.netxms.ui.eclipse.filemanager.widgets.ServerFileSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class StartServerToAgentFileUploadDialog
extends Dialog {
    private ServerFileSelector fileSelector;
    private LabeledText textRemoteFile;
    private Button checkJobOnHold;
    private ServerFile serverFile;
    private String remoteFileName;
    private boolean createJobOnHold;

    public StartServerToAgentFileUploadDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Start File Upload");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.fileSelector = new ServerFileSelector(dialogArea, 0);
        this.fileSelector.setLabel("Server file");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.fileSelector.setLayoutData(gd);
        this.textRemoteFile = new LabeledText(dialogArea, 0);
        this.textRemoteFile.setLabel("Remote file name (leave blank for upload to agent's file store)");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textRemoteFile.setLayoutData((Object)gd);
        this.checkJobOnHold = new Button(dialogArea, 32);
        this.checkJobOnHold.setText("Create upload job but don't start it (job will be in \"on hold\" state)");
        return dialogArea;
    }

    protected void okPressed() {
        this.serverFile = this.fileSelector.getFile();
        if (this.serverFile == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select file for upload");
            return;
        }
        this.remoteFileName = this.textRemoteFile.getText().trim();
        this.createJobOnHold = this.checkJobOnHold.getSelection();
        super.okPressed();
    }

    public ServerFile getServerFile() {
        return this.serverFile;
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    public boolean isCreateJobOnHold() {
        return this.createJobOnHold;
    }
}

