/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.tools;

import org.netxms.client.GeoLocation;

public class MapAccessor {
    public static final int MAX_MAP_WIDTH = 4096;
    public static final int MAX_MAP_HEIGHT = 4096;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private int mapWidth = 640;
    private int mapHeight = 640;
    private int zoom = 10;
    private double spanLat = 0.0;
    private double spanLon = 0.0;
    private boolean sensor = false;

    public MapAccessor(double lattitude, double longitude) {
        this.latitude = lattitude;
        this.longitude = longitude;
    }

    public MapAccessor(double lattitude, double longitude, int zoom) {
        this.latitude = lattitude;
        this.longitude = longitude;
        this.zoom = zoom;
    }

    public MapAccessor(double lattitude, double longitude, int zoom, int mapWidth, int mapHeight) {
        this.latitude = lattitude;
        this.longitude = longitude;
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
        this.zoom = zoom;
    }

    public MapAccessor(MapAccessor src) {
        this.latitude = src.latitude;
        this.longitude = src.longitude;
        this.mapWidth = src.mapWidth;
        this.mapHeight = src.mapHeight;
        this.zoom = src.zoom;
        this.spanLat = src.spanLat;
        this.spanLon = src.spanLon;
        this.sensor = src.sensor;
    }

    public MapAccessor(GeoLocation geolocation) {
        this.latitude = geolocation.getLatitude();
        this.longitude = geolocation.getLongitude();
        this.sensor = geolocation.getType() == 2;
    }

    public String generateUrl() {
        StringBuilder sb = new StringBuilder("http://staticmap.openstreetmap.de/staticmap.php?maptype=mapnik&format=png32&center=");
        sb.append(this.latitude);
        sb.append(',');
        sb.append(this.longitude);
        if (this.spanLat != 0.0 && this.spanLon != 0.0) {
            sb.append("&span=");
            sb.append(this.spanLat);
            sb.append(',');
            sb.append(this.spanLon);
        } else {
            sb.append("&zoom=");
            sb.append(this.zoom);
        }
        sb.append("&size=");
        sb.append(this.mapWidth);
        sb.append('x');
        sb.append(this.mapHeight);
        return sb.toString();
    }

    public boolean isValid() {
        if (this.mapWidth < 1 || this.mapHeight < 1) {
            return false;
        }
        return this.zoom >= 0 && this.zoom <= 18;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapWidth(int mapWidth) {
        this.mapWidth = Math.min(mapWidth, 4096);
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapHeight(int mapHeight) {
        this.mapHeight = Math.min(mapHeight, 4096);
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public boolean isSensor() {
        return this.sensor;
    }

    public void setSensor(boolean sensor) {
        this.sensor = sensor;
    }

    public void setSpan(double lat, double lon) {
        this.spanLat = lat;
        this.spanLon = lon;
    }

    public double getSpanLatitude() {
        return this.spanLat;
    }

    public double getSpanLongitude() {
        return this.spanLon;
    }

    public GeoLocation getCenterPoint() {
        return new GeoLocation(this.latitude, this.longitude);
    }
}

