/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.internal.MultiValueMap;

public abstract class AutomaticRouter
extends AbstractRouter {
    private ConnectionRouter nextRouter;
    private MultiValueMap connections = new MultiValueMap();

    public Object getConstraint(Connection connection) {
        if (this.next() != null) {
            return this.next().getConstraint(connection);
        }
        return null;
    }

    protected abstract void handleCollision(PointList var1, int var2);

    public void invalidate(Connection conn) {
        if (this.next() != null) {
            this.next().invalidate(conn);
        }
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        HashKey connectionKey = new HashKey(conn);
        ArrayList connectionList = this.connections.get(connectionKey);
        int affected = this.connections.remove(connectionKey, conn);
        if (affected != -1) {
            int i = affected;
            while (i < connectionList.size()) {
                ((Connection)connectionList.get(i)).revalidate();
                ++i;
            }
        } else {
            this.connections.removeValue(conn);
        }
    }

    protected ConnectionRouter next() {
        return this.nextRouter;
    }

    public void remove(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        HashKey connectionKey = new HashKey(conn);
        ArrayList connectionList = this.connections.get(connectionKey);
        if (connectionList != null) {
            int index = this.connections.remove(connectionKey, conn);
            int i = index + 1;
            while (i < connectionList.size()) {
                ((Connection)connectionList.get(i)).revalidate();
                ++i;
            }
        }
        if (this.next() != null) {
            this.next().remove(conn);
        }
    }

    public void route(Connection conn) {
        if (this.next() != null) {
            this.next().route(conn);
        } else {
            conn.getPoints().removeAllPoints();
            this.setEndPoints(conn);
        }
        if (conn.getPoints().size() == 2) {
            PointList points = conn.getPoints();
            HashKey connectionKey = new HashKey(conn);
            ArrayList connectionList = this.connections.get(connectionKey);
            if (connectionList != null) {
                int index;
                if (connectionList.contains(conn)) {
                    index = connectionList.indexOf(conn) + 1;
                } else {
                    index = connectionList.size() + 1;
                    this.connections.put(connectionKey, conn);
                }
                this.handleCollision(points, index);
                conn.setPoints(points);
            } else {
                this.connections.put(connectionKey, conn);
            }
        }
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.invalidate(connection);
        if (this.next() != null) {
            this.next().setConstraint(connection, constraint);
        }
    }

    protected void setEndPoints(Connection conn) {
        PointList points = conn.getPoints();
        points.removeAllPoints();
        Point start = this.getStartPoint(conn);
        Point end = this.getEndPoint(conn);
        conn.translateToRelative(start);
        conn.translateToRelative(end);
        points.addPoint(start);
        points.addPoint(end);
        conn.setPoints(points);
    }

    public void setNextRouter(ConnectionRouter router) {
        this.nextRouter = router;
    }

    private class HashKey {
        private ConnectionAnchor anchor1;
        private ConnectionAnchor anchor2;

        HashKey(Connection conn) {
            this.anchor1 = conn.getSourceAnchor();
            this.anchor2 = conn.getTargetAnchor();
        }

        public boolean equals(Object object) {
            boolean isEqual = false;
            if (object instanceof HashKey) {
                HashKey hashKey = (HashKey)object;
                ConnectionAnchor hkA1 = hashKey.getFirstAnchor();
                ConnectionAnchor hkA2 = hashKey.getSecondAnchor();
                isEqual = hkA1.equals(this.anchor1) && hkA2.equals(this.anchor2) || hkA1.equals(this.anchor2) && hkA2.equals(this.anchor1);
            }
            return isEqual;
        }

        public ConnectionAnchor getFirstAnchor() {
            return this.anchor1;
        }

        public ConnectionAnchor getSecondAnchor() {
            return this.anchor2;
        }

        public int hashCode() {
            return this.anchor1.hashCode() ^ this.anchor2.hashCode();
        }
    }
}

