/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciData;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardDciInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class ComparisonChartElement
extends ElementWidget {
    protected DataComparisonChart chart;
    protected NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private Runnable refreshTimer;
    private boolean updateInProgress = false;

    public ComparisonChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.setLayout((Layout)new FillLayout());
    }

    protected void startRefreshTimer() {
        final Display display = this.getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (ComparisonChartElement.this.isDisposed()) {
                    return;
                }
                ComparisonChartElement.this.refreshData(ComparisonChartElement.this.getDciList());
                display.timerExec(30000, (Runnable)this);
            }
        };
        display.timerExec(30000, this.refreshTimer);
        this.refreshData(this.getDciList());
    }

    protected void refreshData(final DashboardDciInfo[] dciList) {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        ConsoleJob job = new ConsoleJob("Get DCI values for history graph", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard", "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < dciList.length) {
                    final DciData data = ComparisonChartElement.this.session.getCollectedData(dciList[i].nodeId, dciList[i].dciId, null, null, 1);
                    final int index = i++;
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!((Widget)(this).ComparisonChartElement.this.chart).isDisposed()) {
                                (this).ComparisonChartElement.this.chart.updateParameter(index, data.getLastValue().getValueAsDouble(), false);
                            }
                        }
                    });
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!((Widget)(this).ComparisonChartElement.this.chart).isDisposed()) {
                            (this).ComparisonChartElement.this.chart.refresh();
                        }
                        ComparisonChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get DCI values for comparision chart";
            }

            protected void jobFailureHandler() {
                ComparisonChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }
        };
        job.setUser(false);
        job.start();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 250) {
            size.y = 250;
        }
        return size;
    }

    protected abstract DashboardDciInfo[] getDciList();
}

