/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ObjectSelector
extends AbstractSelector {
    private long objectId = 0L;
    private Class<? extends GenericObject> objectClass = Node.class;
    private Set<Integer> classFilter = null;
    private String emptySelectionName = "<none>";

    public ObjectSelector(Composite parent, int style) {
        super(parent, style);
        this.setText(this.emptySelectionName);
    }

    protected void selectionButtonHandler() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, this.classFilter);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            GenericObject[] objects = dlg.getSelectedObjects(this.objectClass);
            if (objects.length > 0) {
                this.objectId = objects[0].getObjectId();
                this.setText(objects[0].getObjectName());
            } else {
                this.objectId = 0L;
                this.setText(this.emptySelectionName);
            }
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
        if (objectId == 0L) {
            this.setText(this.emptySelectionName);
        } else {
            GenericObject object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(objectId);
            this.setText(object != null ? object.getObjectName() : "<" + Long.toString(objectId) + ">");
        }
    }

    public Class<? extends GenericObject> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class<? extends GenericObject> objectClass) {
        this.objectClass = objectClass;
    }

    public String getEmptySelectionName() {
        return this.emptySelectionName;
    }

    public void setEmptySelectionName(String emptySelectionName) {
        this.emptySelectionName = emptySelectionName;
    }

    public Set<Integer> getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Set<Integer> classFilter) {
        this.classFilter = classFilter;
    }
}

