/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DciComparator
extends ViewerComparator {
    private DciLabelProvider labelProvider;

    public DciComparator(DciLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        DataCollectionItem dci1 = (DataCollectionItem)e1;
        DataCollectionItem dci2 = (DataCollectionItem)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 0: {
                result = (int)(dci1.getId() - dci2.getId());
                break;
            }
            case 2: {
                result = dci1.getDescription().compareToIgnoreCase(dci2.getDescription());
                break;
            }
            case 3: {
                result = dci1.getName().compareToIgnoreCase(dci2.getName());
                break;
            }
            case 5: {
                result = dci1.getPollingInterval() - dci2.getPollingInterval();
                break;
            }
            case 6: {
                result = dci1.getRetentionTime() - dci2.getRetentionTime();
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: {
                String text1 = this.labelProvider.getColumnText(e1, column);
                String text2 = this.labelProvider.getColumnText(e2, column);
                result = text1.compareToIgnoreCase(text2);
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

