/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentParameter;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.datacollection.dialogs.AbstractSelectParamDlg;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SelectAgentParamDlg
extends AbstractSelectParamDlg {
    private Button queryButton;
    private Action actionQuery = new Action("&Query..."){

        public void run() {
            SelectAgentParamDlg.this.querySelectedParameter();
        }
    };

    public SelectAgentParamDlg(Shell parentShell, long nodeId) {
        super(parentShell, nodeId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.queryButton = new Button(parent, 8);
        this.queryButton.setText("&Query...");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.queryButton.setLayoutData((Object)gd);
        this.queryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectAgentParamDlg.this.querySelectedParameter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IAction)this.actionQuery);
    }

    @Override
    protected void fillParameterList() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Get list of supported parameters for " + this.object.getObjectName(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                return "Unable to retrieve list of supported parameters";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List parameters = session.getSupportedParameters(SelectAgentParamDlg.this.object.getObjectId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).SelectAgentParamDlg.this.viewer.setInput((Object)parameters.toArray());
                    }
                });
            }
        }.start();
    }

    protected void querySelectedParameter() {
        String n;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentParameter p = (AgentParameter)selection.getFirstElement();
        if (p.getName().contains("(*)")) {
            InputDialog dlg = new InputDialog(this.getShell(), "Instance", "Instance for parameter", "", null);
            if (dlg.open() != 0) {
                return;
            }
            n = p.getName().replace("(*)", "(" + dlg.getValue() + ")");
        } else {
            n = p.getName();
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final String name = n;
        new ConsoleJob("Query agent", null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String value = session.queryParameter(SelectAgentParamDlg.this.object.getObjectId(), 1, name);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)SelectAgentParamDlg.this.getShell(), (String)"Current value", (String)("Current value is \"" + value + "\""));
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get current parameter value";
            }
        }.start();
    }

    @Override
    protected String getConfigurationPrefix() {
        return "SelectAgentParamDlg";
    }
}

