/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;

public class Capabilities
extends TableElement {
    public Capabilities(Composite parent, GenericObject object) {
        super(parent, object);
    }

    @Override
    protected String getTitle() {
        return "Capabilities";
    }

    @Override
    protected void fillTable() {
        if (!(this.getObject() instanceof Node)) {
            return;
        }
        Node node = (Node)this.getObject();
        this.addFlag("isAgent", (node.getFlags() & 2) != 0);
        this.addFlag("isBridge", (node.getFlags() & 4) != 0);
        this.addFlag("isCDP", (node.getFlags() & 0x200) != 0);
        this.addFlag("isDot1x", (node.getFlags() & 0x4000) != 0);
        this.addFlag("isLLDP", (node.getFlags() & 0x800) != 0);
        this.addFlag("isNDP", (node.getFlags() & 0x400) != 0);
        this.addFlag("isPrinter", (node.getFlags() & 0x20) != 0);
        this.addFlag("isRouter", (node.getFlags() & 8) != 0);
        this.addFlag("isSNMP", (node.getFlags() & 1) != 0);
        this.addFlag("isSTP", (node.getFlags() & 0x8000) != 0);
        this.addFlag("isVRRP", (node.getFlags() & 0x1000) != 0);
        if ((node.getFlags() & 1) != 0) {
            this.addPair("snmpPort", Integer.toString(node.getSnmpPort()));
            this.addPair("snmpVersion", this.getSnmpVersionName(node.getSnmpVersion()));
        }
    }

    private void addFlag(String name, boolean value) {
        this.addPair(name, value ? "Yes" : "No");
    }

    private String getSnmpVersionName(int version) {
        switch (version) {
            case 0: {
                return "1";
            }
            case 1: {
                return "2c";
            }
            case 3: {
                return "3";
            }
        }
        return "???";
    }

    @Override
    public boolean isApplicableForObject(GenericObject object) {
        return object instanceof Node;
    }
}

