/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;

public class Table {
    private String title;
    private List<String> columnNames;
    private List<Integer> columnFormats;
    private List<List<String>> data;

    public Table() {
        this.columnNames = new ArrayList<String>(0);
        this.columnFormats = new ArrayList<Integer>(0);
        this.data = new ArrayList<List<String>>(0);
    }

    public Table(NXCPMessage msg) {
        this.title = msg.getVariableAsString(168L);
        int columnCount = msg.getVariableAsInteger(329L);
        this.columnNames = new ArrayList<String>(columnCount);
        this.columnFormats = new ArrayList<Integer>(columnCount);
        long varId = 0x10000000L;
        int i = 0;
        while (i < columnCount) {
            this.columnNames.add(msg.getVariableAsString(varId++));
            this.columnFormats.add(msg.getVariableAsInteger(varId++));
            ++i;
            varId += 8L;
        }
        int totalRowCount = msg.getVariableAsInteger(328L);
        this.data = new ArrayList<List<String>>(totalRowCount);
        int rowCount = msg.getVariableAsInteger(167L);
        varId = 0x20000000L;
        for (int i2 = 0; i2 < rowCount; ++i2) {
            ArrayList<String> row = new ArrayList<String>(columnCount);
            for (int j = 0; j < columnCount; ++j) {
                row.add(msg.getVariableAsString(varId++));
            }
            this.data.add(row);
        }
    }

    public void addDataFromMessage(NXCPMessage msg) {
        int rowCount = msg.getVariableAsInteger(167L);
        long varId = 0x20000000L;
        for (int i = 0; i < rowCount; ++i) {
            ArrayList<String> row = new ArrayList<String>(this.columnNames.size());
            for (int j = 0; j < this.columnNames.size(); ++j) {
                row.add(msg.getVariableAsString(varId++));
            }
            this.data.add(row);
        }
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int column) throws IndexOutOfBoundsException {
        return this.columnNames.get(column);
    }

    public int getColumnFormat(int column) throws IndexOutOfBoundsException {
        return this.columnFormats.get(column);
    }

    public int getColumnIndex(String name) {
        return this.columnNames.indexOf(name);
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public Integer[] getColumnFormats() {
        return this.columnFormats.toArray(new Integer[this.columnFormats.size()]);
    }

    public String getCell(int row, int column) throws IndexOutOfBoundsException {
        List<String> rowData = this.data.get(row);
        return rowData.get(column);
    }

    public List<String> getRow(int row) throws IndexOutOfBoundsException {
        return this.data.get(row);
    }

    public Object[] getAllRows() {
        Object[] rows = new Object[this.data.size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.data.get(i);
        }
        return rows;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table");
        sb.append("{columns=").append(this.columnNames);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }
}

