/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.users;

import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.base.NXCPMessage;

public class User
extends AbstractUserObject {
    public static final int AUTH_NETXMS_PASSWORD = 0;
    public static final int AUTH_RADIUS = 1;
    public static final int AUTH_CERTIFICATE = 2;
    public static final int AUTH_CERTIFICATE_OR_PASSWORD = 3;
    public static final int AUTH_CERTIFICATE_OR_RADIUS = 4;
    public static final int MAP_CERT_BY_SUBJECT = 0;
    public static final int MAP_CERT_BY_PUBKEY = 1;
    int authMethod;
    int certMappingMethod;
    String certMappingData;
    String fullName;

    public User(String name) {
        super(name);
        this.fullName = "";
    }

    public User(User src) {
        super(src);
        this.authMethod = src.authMethod;
        this.certMappingMethod = src.certMappingMethod;
        this.certMappingData = new String(src.certMappingData);
        this.fullName = new String(src.fullName);
    }

    public User(NXCPMessage msg) {
        super(msg);
        this.authMethod = msg.getVariableAsInteger(16L);
        this.fullName = msg.getVariableAsString(40L);
        this.certMappingMethod = msg.getVariableAsInteger(279L);
        this.certMappingData = msg.getVariableAsString(280L);
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setVariableInt16(16L, this.authMethod);
        msg.setVariable(40L, this.fullName);
        msg.setVariableInt16(279L, this.certMappingMethod);
        msg.setVariable(280L, this.certMappingData);
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(int authMethod) {
        this.authMethod = authMethod;
    }

    public int getCertMappingMethod() {
        return this.certMappingMethod;
    }

    public void setCertMappingMethod(int certMappingMethod) {
        this.certMappingMethod = certMappingMethod;
    }

    public String getCertMappingData() {
        return this.certMappingData;
    }

    public void setCertMappingData(String certMappingData) {
        this.certMappingData = certMappingData;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new User(this);
    }
}

