/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class Comments
extends PropertyPage {
    private GenericObject object;
    private Text comments;
    private String initialComments;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (GenericObject)this.getElement().getAdapter(GenericObject.class);
        this.initialComments = this.object.getComments();
        if (this.initialComments == null) {
            this.initialComments = "";
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.comments = new Text(dialogArea, 2818);
        this.comments.setText(this.initialComments);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.comments.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (this.initialComments.equals(this.comments.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final String newComments = new String(this.comments.getText());
        new ConsoleJob("Update comments for object " + this.object.getObjectName(), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ((NXCSession)ConsoleSharedData.getSession()).updateObjectComments(Comments.this.object.getObjectId(), newComments);
                Comments.this.initialComments = newComments;
            }

            protected String getErrorMessage() {
                return "Cannot change comments";
            }

            protected void jobFinalize() {
                if (isApply) {
                    new UIJob("Update \"Comments\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Comments.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.comments.setText("");
    }
}

