/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.views;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.charts.views.HistoricalDataView;
import org.netxms.ui.eclipse.charts.views.helpers.GraphTreeContentProvider;
import org.netxms.ui.eclipse.charts.views.helpers.GraphTreeLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class PredefinedGraphTree
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.charts.views.PredefinedGraphTree";
    private TreeViewer viewer;
    private NXCSession session;
    private RefreshAction actionRefresh;
    private Action actionOpen;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new GraphTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GraphTreeLabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PredefinedGraphTree.this.actionOpen.run();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PredefinedGraphTree.this.viewer.getSelection();
                Iterator it = selection.iterator();
                boolean enabled = false;
                while (it.hasNext()) {
                    if (!(it.next() instanceof GraphSettings)) continue;
                    enabled = true;
                    break;
                }
                PredefinedGraphTree.this.actionOpen.setEnabled(enabled);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.reloadGraphList();
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                PredefinedGraphTree.this.reloadGraphList();
            }
        };
        this.actionOpen = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)PredefinedGraphTree.this.viewer.getSelection();
                for (Object o : selection) {
                    if (!(o instanceof GraphSettings)) continue;
                    PredefinedGraphTree.this.showPredefinedGraph((GraphSettings)o);
                }
            }
        };
        this.actionOpen.setText("&Open");
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PredefinedGraphTree.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionOpen);
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionOpen);
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void reloadGraphList() {
        new ConsoleJob("Load list of predefined graphs", (IWorkbenchPart)this, "org.netxms.ui.eclipse.charts", "org.netxms.ui.eclipse.charts"){

            protected String getErrorMessage() {
                return "Cannot get list of predefined graphs";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = PredefinedGraphTree.this.session.getPredefinedGraphs();
                new UIJob("Upfate graph list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        PredefinedGraphTree.this.viewer.setInput((Object)list);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }.start();
    }

    private void showPredefinedGraph(GraphSettings gs) {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(gs.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            encodedName = "___ERROR___";
        }
        String id = "org.netxms.ui.eclipse.charts.predefinedGraph&" + encodedName;
        try {
            HistoricalDataView g = (HistoricalDataView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.charts.views.HistoryGraph", id, 1);
            if (g != null) {
                g.initPredefinedGraph(gs);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("Error opening graph view: " + e.getMessage()));
        }
    }
}

