/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ObjectSelector
extends AbstractSelector {
    private long objectId = 0L;
    private int objectClass = 2;
    private String emptySelectionName = Messages.getString("ObjectSelector.none");

    public ObjectSelector(Composite parent, int style) {
        super(parent, style);
        this.setText(this.emptySelectionName);
    }

    protected void selectionButtonHandler() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, null);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            GenericObject[] objects = dlg.getSelectedObjects(this.objectClass);
            if (objects.length > 0) {
                this.objectId = objects[0].getObjectId();
                this.setText(objects[0].getObjectName());
            } else {
                this.objectId = 0L;
                this.setText(this.emptySelectionName);
            }
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
        if (objectId == 0L) {
            this.setText(this.emptySelectionName);
        } else {
            GenericObject object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(objectId);
            this.setText(object != null ? object.getObjectName() : Messages.getString("ObjectSelector.unknown"));
        }
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(int objectClass) {
        this.objectClass = objectClass;
    }

    public String getEmptySelectionName() {
        return this.emptySelectionName;
    }

    public void setEmptySelectionName(String emptySelectionName) {
        this.emptySelectionName = emptySelectionName;
    }
}

