/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.base.Glob;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectTreeFilter
extends ViewerFilter {
    private String filterString = null;
    private Map<Long, GenericObject> objectList = null;
    private GenericObject lastMatch = null;
    private long[] rootObjects = null;
    private Set<Integer> classFilter = null;
    private boolean usePatternMatching = false;

    public ObjectTreeFilter(long[] rootObjects, Set<Integer> classFilter) {
        if (rootObjects != null) {
            this.rootObjects = new long[rootObjects.length];
            System.arraycopy(rootObjects, 0, this.rootObjects, 0, rootObjects.length);
        }
        this.classFilter = classFilter;
    }

    private boolean matchFilterString(String value) {
        if (this.filterString == null) {
            return true;
        }
        return this.usePatternMatching ? Glob.matchIgnoreCase((String)this.filterString, (String)value) : value.toLowerCase().startsWith(this.filterString);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.classFilter != null && !this.classFilter.contains(((GenericObject)element).getObjectClass())) {
            return false;
        }
        if (this.objectList == null) {
            return true;
        }
        boolean pass = this.objectList.containsKey(((GenericObject)element).getObjectId());
        if (!pass && ((GenericObject)element).getNumberOfChilds() > 0) {
            for (GenericObject obj : this.objectList.values()) {
                if (!obj.isChildOf(((GenericObject)element).getObjectId())) continue;
                pass = true;
                break;
            }
        }
        return pass;
    }

    public void setFilterString(String filterString) {
        boolean fullSearch = true;
        if (filterString != null && !filterString.isEmpty()) {
            boolean bl = this.usePatternMatching = filterString.contains("*") || filterString.contains("?");
            if (this.usePatternMatching) {
                this.filterString = String.valueOf(filterString.toLowerCase()) + "*";
            } else {
                String newFilterString = filterString.toLowerCase();
                if (this.filterString != null && newFilterString.startsWith(this.filterString)) {
                    fullSearch = false;
                }
                this.filterString = newFilterString;
            }
        } else {
            this.filterString = null;
            this.usePatternMatching = false;
        }
        this.updateObjectList(fullSearch);
    }

    private void updateObjectList(boolean doFullSearch) {
        if (this.filterString != null) {
            if (doFullSearch) {
                GenericObject[] fullList = ((NXCSession)ConsoleSharedData.getSession()).getAllObjects();
                this.objectList = new HashMap<Long, GenericObject>();
                int i = 0;
                while (i < fullList.length) {
                    if (this.matchFilterString(fullList[i].getObjectName()) && (this.rootObjects == null || fullList[i].isChildOf(this.rootObjects))) {
                        this.objectList.put(fullList[i].getObjectId(), fullList[i]);
                        this.lastMatch = fullList[i];
                    }
                    ++i;
                }
            } else {
                this.lastMatch = null;
                Iterator<GenericObject> it = this.objectList.values().iterator();
                while (it.hasNext()) {
                    GenericObject obj = it.next();
                    if (!this.matchFilterString(obj.getObjectName())) {
                        it.remove();
                        continue;
                    }
                    this.lastMatch = obj;
                }
            }
        } else {
            this.objectList = null;
            this.lastMatch = null;
        }
    }

    public final GenericObject getLastMatch() {
        return this.lastMatch;
    }

    public GenericObject getParent(GenericObject childObject) {
        GenericObject[] parents;
        GenericObject[] genericObjectArray = parents = childObject.getParentsAsArray();
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            GenericObject object = genericObjectArray[n2];
            if (object != null && (this.rootObjects == null || object.isChildOf(this.rootObjects))) {
                return object;
            }
            ++n2;
        }
        return null;
    }
}

