/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.EventTemplateComparator;
import org.netxms.ui.eclipse.eventmanager.EventTemplateLabelProvider;
import org.netxms.ui.eclipse.eventmanager.dialogs.helpers.EventListFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class EventSelectionDialog
extends Dialog {
    private boolean multiSelection;
    private Text filterText;
    private TableViewer eventList;
    private EventTemplate[] selectedEvents;
    private EventListFilter filter;

    public EventSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.multiSelection = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Event");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectEvent.cx"), settings.getInt("SelectEvent.cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText("Filter:");
        this.filterText = new Text(dialogArea, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterText.setLayoutData((Object)gd);
        String filterString = settings.get("SelectEvent.Filter");
        if (filterString != null) {
            this.filterText.setText(filterString);
        }
        String[] names = new String[]{"Code", "Name"};
        int[] widths = new int[]{80, 350};
        this.eventList = new SortableTableViewer(dialogArea, names, widths, 1, 128, 0x10800 | (this.multiSelection ? 2 : 4) | 0x100 | 0x200);
        this.eventList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eventList.setComparator((ViewerComparator)new EventTemplateComparator());
        this.eventList.setLabelProvider((IBaseLabelProvider)new EventTemplateLabelProvider());
        this.filter = new EventListFilter();
        if (filterString != null) {
            this.filter.setFilterString(filterString);
        }
        this.eventList.addFilter((ViewerFilter)this.filter);
        this.eventList.setInput((Object)((NXCSession)ConsoleSharedData.getSession()).getCachedEventTemplates());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 350;
        this.eventList.getTable().setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventSelectionDialog.this.filter.setFilterString(EventSelectionDialog.this.filterText.getText());
                EventSelectionDialog.this.eventList.refresh();
            }
        });
        this.eventList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EventSelectionDialog.this.okPressed();
            }
        });
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.eventList.getSelection();
        List list = selection.toList();
        this.selectedEvents = list.toArray(new EventTemplate[list.size()]);
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectEvent.cx", size.x);
        settings.put("SelectEvent.cy", size.y);
        settings.put("SelectEvent.Filter", this.filterText.getText());
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public EventTemplate[] getSelectedEvents() {
        return this.selectedEvents;
    }
}

