/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;

public class DashboardElementsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] ELEMENT_TYPES = new String[]{"Label", "Line Chart", "Bar Chart", "Pie Chart", "Tube Chart", "Status Chart", "Status Indicator", "Dashboard", "Network Map", "Custom Widget", "Geo Map"};
    private static final String[] H_ALIGH = new String[]{"FILL", "CENTER", "LEFT", "RIGHT"};
    private static final String[] V_ALIGH = new String[]{"FILL", "CENTER", "TOP", "BOTTOM"};

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DashboardElement de = (DashboardElement)element;
        switch (columnIndex) {
            case 0: {
                try {
                    return ELEMENT_TYPES[de.getType()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "<unknown>";
                }
            }
            case 1: {
                try {
                    DashboardElementLayout layout = DashboardElementLayout.createFromXml(de.getLayout());
                    return String.valueOf(Integer.toString(layout.horizontalSpan)) + " / " + Integer.toString(layout.verticalSpan);
                }
                catch (Exception exception) {
                    return "1 / 1";
                }
            }
            case 2: {
                try {
                    DashboardElementLayout layout = DashboardElementLayout.createFromXml(de.getLayout());
                    try {
                        return String.valueOf(H_ALIGH[layout.horizontalAlignment]) + " / " + V_ALIGH[layout.vertcalAlignment];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return "<unknown>";
                    }
                }
                catch (Exception exception) {
                    return "FILL / FILL";
                }
            }
        }
        return null;
    }
}

