/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.views.helpers.ConnectionPointComparator;
import org.netxms.ui.eclipse.topology.views.helpers.ConnectionPointLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class HostSearchResults
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.HostSearchResults";
    public static final int COLUMN_SEQUENCE = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_MAC_ADDRESS = 3;
    public static final int COLUMN_SWITCH = 4;
    public static final int COLUMN_PORT = 5;
    private static final String TABLE_CONFIG_PREFIX = "HostSearchResults";
    private SortableTableViewer viewer;
    private List<ConnectionPoint> results = new ArrayList<ConnectionPoint>();
    private Action actionClearLog;

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"Seq.", "Node", "Interface", "MAC", "Switch", "Port"};
        int[] widths = new int[]{70, 120, 120, 90, 120, 120};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65536);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ConnectionPointLabelProvider labelProvider = new ConnectionPointLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ConnectionPointComparator(labelProvider));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)HostSearchResults.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)HostSearchResults.TABLE_CONFIG_PREFIX);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionClearLog = new Action("Clear search log"){

            public void run() {
                HostSearchResults.this.results.clear();
                HostSearchResults.this.viewer.setInput((Object)HostSearchResults.this.results.toArray());
            }
        };
        this.actionClearLog.setImageDescriptor(SharedIcons.CLEAR_LOG);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionClearLog);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClearLog);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HostSearchResults.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClearLog);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void addResult(ConnectionPoint cp) {
        cp.setData((Object)this.results.size());
        this.results.add(cp);
        this.viewer.setInput((Object)this.results.toArray());
    }

    public static void showConnection(ConnectionPoint cp) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (cp == null) {
            MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)"Connection point information cannot be found");
            return;
        }
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        try {
            Node host = (Node)session.findObjectById(cp.getLocalNodeId());
            Node bridge = (Node)session.findObjectById(cp.getNodeId());
            Interface iface = (Interface)session.findObjectById(cp.getInterfaceId());
            if (bridge != null && iface != null) {
                if (host != null) {
                    MessageDialog.openInformation((Shell)shell, (String)"Connection Point", (String)("Node " + host.getObjectName() + " is connected to network switch " + bridge.getObjectName() + " port " + iface.getObjectName()));
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)"Connection Point", (String)("Node with MAC address " + cp.getLocalMacAddress() + " is connected to network switch " + bridge.getObjectName() + " port " + iface.getObjectName()));
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart part = page.showView(ID);
                ((HostSearchResults)part).addResult(cp);
            } else {
                MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)"Connection point information cannot be found");
            }
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)("Connection point information cannot be shown: " + e.getMessage()));
        }
    }

    public void dispose() {
        super.dispose();
    }
}

