/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.animation;

import org.eclipse.swt.widgets.Display;
import org.netxms.nebula.animation.effects.IEffect;

public class AnimationRunner {
    int delay = 20;
    IEffect effect;
    boolean running = false;
    protected long startTime = -1L;

    public AnimationRunner() {
        this(50);
    }

    public AnimationRunner(int framerate) {
        this.delay = 1000 / framerate;
    }

    public IEffect getEffect() {
        return this.effect;
    }

    public void runEffect(IEffect effect) {
        this.cancel();
        this.effect = effect;
        this.startTime = -1L;
        this.startEffect();
    }

    public void cancel() {
        if (this.effect != null && !this.effect.isDone()) {
            this.effect.cancel();
            this.effect = null;
        }
    }

    private long getCurrentTime() {
        long time = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = time;
        }
        return time - this.startTime;
    }

    private void startEffect() {
        if (this.running) {
            return;
        }
        this.running = true;
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                if (AnimationRunner.this.effect != null && !AnimationRunner.this.effect.isDone()) {
                    Display.getCurrent().timerExec(AnimationRunner.this.delay, (Runnable)this);
                    AnimationRunner.this.effect.doEffect(AnimationRunner.this.getCurrentTime());
                } else {
                    AnimationRunner.this.running = false;
                }
            }
        });
    }
}

