/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.widgets.gallery;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.netxms.nebula.animation.AnimationRunner;
import org.netxms.nebula.animation.movement.IMovement;
import org.netxms.nebula.animation.movement.LinearInOut;
import org.netxms.nebula.widgets.gallery.AbstractGridGroupRenderer;
import org.netxms.nebula.widgets.gallery.Gallery;
import org.netxms.nebula.widgets.gallery.GalleryGroupResizeEffect;
import org.netxms.nebula.widgets.gallery.GalleryItem;
import org.netxms.nebula.widgets.gallery.RendererHelper;

public class DefaultGalleryGroupRenderer
extends AbstractGridGroupRenderer {
    private AnimationRunner animationRunner = new AnimationRunner();
    private static final String PARENTHESIS_OPEN = " (";
    private static final String PARENTHESIS_CLOSE = ")";
    private int fontHeight = 0;
    private int titleHeight = this.fontHeight + 5;
    private Color titleForeground;
    private Color descriptionColor;
    private Color titleBackground = null;
    private boolean titleBackgroundGradient = true;
    private Color titleBackground2 = null;
    private int maxImageWidth = 32;
    private int maxImageHeight = 32;
    private Point imageSize = null;
    private boolean fillIfSingleColumn = false;
    private boolean fill = false;
    boolean marginCalculated = false;
    private Font font = null;
    protected boolean animation = false;
    protected int animationLength = 500;
    protected IMovement animationOpenMovement = new LinearInOut();
    protected IMovement animationCloseMovement = new LinearInOut();
    protected static final String DATA_ANIMATION = "org.netxms.nebula.gallery.internal.animation";

    public void setGallery(Gallery gallery) {
        super.setGallery(gallery);
        if (this.titleForeground == null) {
            this.setTitleForeground(null);
        }
        if (this.titleBackground == null) {
            this.setTitleBackgroundGradient(null, null);
        }
        if (this.descriptionColor == null) {
            this.descriptionColor = gallery.getDisplay().getSystemColor(10);
        }
    }

    protected void drawGroupBackground(GC gc, GalleryItem item, int x, int y, int width, int height) {
        Color itemLocalBackground = item.getBackground(true);
        if (!this.titleBackgroundGradient || itemLocalBackground != null) {
            gc.setBackground(itemLocalBackground != null ? itemLocalBackground : this.titleBackground);
            gc.fillRectangle(x, y, width, height);
        } else {
            gc.setBackground(this.titleBackground);
            gc.setForeground(this.titleBackground2);
            gc.fillGradientRectangle(x, y, width, height, true);
        }
    }

    protected int drawGroupToggleButton(GC gc, int x, int y, GalleryItem group) {
        if (!this.isAlwaysExpanded()) {
            int xShift = RendererHelper.getShift(this.titleHeight, 9);
            int yShift = RendererHelper.getShift(this.titleHeight, 9);
            int toggleX = x + xShift;
            int toggleY = y + yShift;
            gc.setBackground(gc.getDevice().getSystemColor(25));
            gc.fillRectangle(toggleX, toggleY, 8, 8);
            gc.setForeground(gc.getDevice().getSystemColor(21));
            gc.drawLine(toggleX + 2, toggleY + 4, toggleX + 6, toggleY + 4);
            if (!this.expanded) {
                gc.drawLine(toggleX + 4, toggleY + 2, toggleX + 4, toggleY + 6);
            }
            gc.setForeground(gc.getDevice().getSystemColor(18));
            gc.drawRectangle(toggleX, toggleY, 8, 8);
        }
        return this.titleHeight + this.minMargin;
    }

    protected Rectangle getToggleButtonBounds() {
        return new Rectangle(this.minMargin + RendererHelper.getShift(this.titleHeight, 9), RendererHelper.getShift(this.titleHeight, 9), 9, 9);
    }

    protected int getGroupHeight(GalleryItem group) {
        int groupHeight = this.titleHeight;
        if (group.getImage() != null) {
            Point imageSize = RendererHelper.getBestSize(group.getImage().getBounds().width, group.getImage().getBounds().height, this.maxImageWidth, this.maxImageHeight);
            groupHeight = Math.max(this.titleHeight, imageSize.y + 2 * this.minMargin);
        }
        int lineCount = 1;
        if (group.getText(1) != null && !"".equals(group.getText(1))) {
            ++lineCount;
        }
        if (group.getText(2) != null && !"".equals(group.getText(2))) {
            ++lineCount;
        }
        groupHeight = Math.max(groupHeight, lineCount * (this.fontHeight + 2) + 2);
        return groupHeight;
    }

    protected void drawGroup(GC gc, GalleryItem group, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
        if (this.fill) {
            return;
        }
        this.imageSize = null;
        if (group.getImage() != null) {
            this.imageSize = RendererHelper.getBestSize(group.getImage().getBounds().width, group.getImage().getBounds().height, this.maxImageWidth, this.maxImageHeight);
        }
        int groupHeight = this.getGroupHeight(group);
        if (this.gallery.isVertical()) {
            int baseX = x + this.minMargin;
            int baseY = y;
            if (group.getImage() != null) {
                baseY += (this.imageSize.y - this.fontHeight) / 2;
            }
            int textY = baseY + 2;
            int i = 1;
            while (i < 3) {
                if (group.getText(i) != null && !"".equals(group.getText(i))) {
                    textY -= this.fontHeight / 2 + 1;
                }
                ++i;
            }
            textY = Math.max(y + 2, textY);
            this.drawGroupBackground(gc, group, x, y, group.width, groupHeight);
            baseX += this.drawGroupToggleButton(gc, baseX, textY - 1, group);
            baseX += this.drawGroupImage(gc, group, baseX, y, this.imageSize);
            gc.setForeground(group.getForeground(true) != null ? group.getForeground(true) : this.titleForeground);
            gc.setFont(this.getFont(group));
            gc.drawText(this.getGroupTitle(group), baseX, textY, true);
            gc.setForeground(this.descriptionColor);
            i = 1;
            while (i < 3) {
                if (group.getText(i) != null && !"".equals(group.getText(i))) {
                    gc.drawText(group.getText(i), baseX, textY + i * (2 + this.fontHeight), true);
                }
                ++i;
            }
        } else {
            Transform transform = new Transform(gc.getDevice());
            transform.rotate(-90.0f);
            gc.setTransform(transform);
            int baseX = x;
            int baseY = y - group.height;
            if (group.getImage() != null) {
                baseX += (this.imageSize.y - this.fontHeight) / 2;
            }
            int textX = baseX + 2;
            int i = 1;
            while (i < 3) {
                if (group.getText(i) != null) {
                    textX -= this.fontHeight / 2 + 1;
                }
                ++i;
            }
            textX = Math.max(x + 2, textX);
            this.drawGroupBackground(gc, group, y - group.height, x, group.height, groupHeight);
            baseY += this.drawGroupToggleButton(gc, baseY, textX - 1, group);
            baseY += this.drawGroupImage(gc, group, baseY, x, this.imageSize);
            gc.setForeground(group.foreground != null ? group.foreground : this.titleForeground);
            gc.setFont(this.getFont(group));
            gc.drawText(this.getGroupTitle(group), baseY, textX, true);
            gc.setForeground(this.descriptionColor);
            i = 1;
            while (i < 3) {
                if (group.getText(i) != null) {
                    gc.drawText(group.getText(i), baseY, textX + i * (2 + this.fontHeight), true);
                }
                ++i;
            }
            gc.setTransform(null);
            transform.dispose();
        }
    }

    private int drawGroupImage(GC gc, GalleryItem group, int x, int y, Point imageSize2) {
        if (imageSize2 == null) {
            return 0;
        }
        Image img = group.getImage();
        Rectangle imgSize = img.getBounds();
        Point offset = RendererHelper.getImageOffset(imageSize2.x, imageSize2.y, this.maxImageWidth, this.getGroupHeight(group));
        gc.drawImage(img, 0, 0, imgSize.width, imgSize.height, x + offset.x, y + offset.y, imageSize2.x, imageSize2.y);
        return this.maxImageWidth + 2 * this.minMargin;
    }

    protected String getGroupTitle(GalleryItem group) {
        StringBuffer titleBuffer = new StringBuffer();
        titleBuffer.append(group.getText());
        titleBuffer.append(PARENTHESIS_OPEN);
        titleBuffer.append(group.getItemCount());
        titleBuffer.append(PARENTHESIS_CLOSE);
        return titleBuffer.toString();
    }

    protected int getGroupOffset(GalleryItem item) {
        if (item.getParentItem() != null) {
            return 0;
        }
        return this.getGroupHeight(item) + this.minMargin;
    }

    public void draw(GC gc, GalleryItem group, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
        this.drawGroup(gc, group, x, y, clipX, clipY, clipWidth, clipHeight);
        int groupOffset = this.getGroupOffset(group);
        if (this.isGroupExpanded(group)) {
            int[] indexes = this.getVisibleItems(group, x, y, clipX, clipY, clipWidth, clipHeight, groupOffset);
            if (this.fill) {
                indexes = new int[]{indexes[0]};
            }
            if (indexes != null && indexes.length > 0) {
                int i = indexes.length - 1;
                while (i >= 0) {
                    boolean selected = group.isSelected(group.getItem(indexes[i]));
                    if (Gallery.DEBUG) {
                        System.out.println("Selected : " + selected + " index : " + indexes[i] + "item : " + (Object)((Object)group.getItem(indexes[i])));
                    }
                    this.drawItem(gc, indexes[i], selected, group, groupOffset);
                    --i;
                }
            }
        }
    }

    public void layout(GC gc, GalleryItem group) {
        Object animationGroupData;
        int countLocal = group.getItemCount();
        double animationRatio = 1.0;
        if (this.animation && (animationGroupData = group.getData(DATA_ANIMATION)) != null && animationGroupData instanceof Double && (animationRatio = ((Double)animationGroupData).doubleValue()) < 0.0) {
            animationRatio = 0.0;
        }
        if (this.gallery.isVertical()) {
            int sizeX = group.width;
            group.height = this.getGroupOffset(group);
            Point l = this.gridLayout(sizeX, countLocal, this.itemWidth);
            int hCount = l.x;
            int vCount = l.y;
            if (this.autoMargin && hCount > 0 && !this.marginCalculated) {
                this.margin = this.calculateMargins(sizeX, hCount, this.itemWidth);
                this.marginCalculated = true;
                if (Gallery.DEBUG) {
                    System.out.println("margin " + this.margin);
                }
            }
            if (this.isGroupExpanded(group)) {
                Point s = this.getSize(hCount, vCount, this.itemWidth, this.itemHeight, this.minMargin, this.margin);
                group.height = (int)((double)group.height + (double)s.y * animationRatio);
                if (Gallery.DEBUG) {
                    System.out.println("group.height " + group.height);
                }
                group.setData("g.h", new Integer(hCount));
                group.setData("g.v", new Integer(vCount));
                if (Gallery.DEBUG) {
                    System.out.println("Hnb" + hCount + "Vnb" + vCount);
                }
                this.fill = this.fillIfSingleColumn && hCount == 1;
            }
        } else {
            int sizeY = group.height;
            group.width = this.getGroupOffset(group);
            Point l = this.gridLayout(sizeY, countLocal, this.itemHeight);
            int vCount = l.x;
            int hCount = l.y;
            if (this.autoMargin && vCount > 0) {
                this.margin = this.calculateMargins(sizeY, vCount, this.itemHeight);
                this.marginCalculated = true;
                if (Gallery.DEBUG) {
                    System.out.println("margin " + this.margin);
                }
            }
            if (this.isGroupExpanded(group)) {
                Point s = this.getSize(hCount, vCount, this.itemWidth, this.itemHeight, this.minMargin, this.margin);
                group.width = (int)((double)group.width + (double)s.x * animationRatio);
                group.setData("g.h", new Integer(hCount));
                group.setData("g.v", new Integer(vCount));
                this.fill = this.fillIfSingleColumn && vCount == 1;
            }
        }
    }

    public void preDraw(GC gc) {
        this.pre(gc);
    }

    public void preLayout(GC gc) {
        this.marginCalculated = false;
        this.pre(gc);
        super.preLayout(gc);
    }

    private void pre(GC myGc) {
        GC gc = myGc;
        boolean gcCreated = false;
        if (gc == null) {
            gc = new GC((Drawable)this.gallery, 0);
            gcCreated = true;
        }
        gc.setFont(this.font);
        this.fontHeight = gc.getFontMetrics().getHeight();
        this.titleHeight = this.fontHeight + 5;
        if (gcCreated) {
            gc.dispose();
        }
    }

    public GalleryItem getItem(GalleryItem group, Point coords) {
        if (!this.isGroupExpanded(group)) {
            return null;
        }
        return super.getItem(group, coords, this.getGroupOffset(group));
    }

    protected void startGroupAnimation(GalleryItem group, boolean doOpen) {
        if (this.animation) {
            IMovement movement;
            int end;
            int start;
            if (group.getData(DATA_ANIMATION) == null) {
                group.setData(DATA_ANIMATION, new Double(!doOpen ? 1 : 0));
            }
            if (doOpen) {
                start = 0;
                end = 1;
                movement = this.animationOpenMovement;
            } else {
                start = 1;
                end = 0;
                movement = this.animationCloseMovement;
            }
            this.animationRunner.runEffect(new GalleryGroupResizeEffect(group, start, end, this.animationLength, movement, null, null));
        }
    }

    public boolean mouseDown(GalleryItem group, MouseEvent e, Point coords) {
        if (this.gallery.isVertical()) {
            if (coords.y - group.y <= this.getGroupHeight(group)) {
                if (!this.isAlwaysExpanded() && coords.x - group.x <= this.getToggleButtonBounds().x + this.getToggleButtonBounds().width && coords.x - group.x > this.getToggleButtonBounds().x) {
                    boolean doOpen = !group.isExpanded();
                    this.startGroupAnimation(group, doOpen);
                    group._setExpanded(doOpen, false);
                    if (!this.isGroupExpanded(group)) {
                        group.deselectAll();
                    }
                    this.gallery.notifyTreeListeners(group, this.isGroupExpanded(group));
                    if (!this.animation) {
                        this.gallery.updateStructuralValues(group, false);
                        this.gallery.updateScrollBarsProperties();
                        this.gallery.redraw();
                    }
                } else if (this.isGroupExpanded(group) && (this.getGallery().getStyle() & 2) > 0) {
                    if ((e.stateMask & SWT.MOD1) == 0) {
                        this.gallery.deselectAll();
                    }
                    group.selectAll();
                    this.gallery.notifySelectionListeners(group, this.gallery.indexOf(group), false);
                    this.gallery.redraw();
                }
                return false;
            }
        } else if (coords.x - group.x <= this.getGroupHeight(group)) {
            if (!this.isAlwaysExpanded() && group.height - coords.y + 5 <= this.getToggleButtonBounds().x + this.getToggleButtonBounds().width && group.height - coords.y + 5 > this.getToggleButtonBounds().x) {
                boolean doOpen = !group.isExpanded();
                this.startGroupAnimation(group, doOpen);
                group._setExpanded(doOpen, false);
                if (!this.isGroupExpanded(group)) {
                    group.deselectAll();
                }
                this.gallery.notifyTreeListeners(group, this.isGroupExpanded(group));
                if (!this.animation) {
                    this.gallery.updateStructuralValues(null, false);
                    this.gallery.updateScrollBarsProperties();
                    this.gallery.redraw();
                }
            } else if (this.isGroupExpanded(group) && (this.getGallery().getStyle() & 2) > 0) {
                if ((e.stateMask & SWT.MOD1) == 0) {
                    this.gallery.deselectAll();
                }
                group.selectAll();
                this.gallery.notifySelectionListeners(group, this.gallery.indexOf(group), false);
                this.gallery.redraw();
            }
            return false;
        }
        return true;
    }

    public Rectangle getSize(GalleryItem item) {
        GalleryItem group = item.getParentItem();
        if (group == null) {
            group = item;
        }
        return super.getSize(item, this.getGroupOffset(group));
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setTitleForeground(Color titleColor) {
        if (titleColor == null) {
            if (this.gallery == null) {
                throw new IllegalArgumentException("Please associate this renderer with a Gallery before trying to reset foreground defaults");
            }
            this.titleForeground = this.gallery.getDisplay().getSystemColor(30);
        } else {
            this.titleForeground = titleColor;
        }
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitleBackground(Color titleBackground) {
        this.titleBackgroundGradient = false;
        this.titleBackground = titleBackground;
    }

    public void setTitleBackgroundGradient(Color gradientBackground, Color gradientForeground) {
        this.titleBackgroundGradient = true;
        if (gradientBackground != null && gradientForeground != null) {
            this.titleBackground = gradientBackground;
            this.titleBackground2 = gradientForeground;
        } else {
            if (this.gallery == null) {
                throw new IllegalArgumentException("Please associate this renderer with a Gallery before trying to reset background defaults");
            }
            this.titleBackground = this.gallery.getDisplay().getSystemColor(31);
            this.titleBackground2 = this.gallery.getDisplay().getSystemColor(32);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            if (this.getGallery() != null) {
                this.getGallery().redraw();
            }
        }
    }

    protected void drawItem(GC gc, int index, boolean selected, GalleryItem parent, int offsetY) {
        if (this.fill) {
            GalleryItem item = parent.getItem(index);
            if (item == null) {
                return;
            }
            GalleryItem gItem = item;
            Rectangle area = this.gallery.getClientArea();
            gItem.x = area.x;
            gItem.y = area.y + this.gallery.translate;
            gItem.height = area.height;
            gItem.width = area.width;
            this.gallery.sendPaintItemEvent(item, index, gc, area.x, area.y, area.width, area.height);
            if (this.gallery.getItemRenderer() != null) {
                this.gallery.getItemRenderer().setSelected(selected);
                this.gallery.getItemRenderer().draw(gc, gItem, index, area.x, area.y, area.width, area.height);
            }
            return;
        }
        super.drawItem(gc, index, selected, parent, offsetY);
    }

    public int getScrollBarIncrement() {
        if (this.fill) {
            if (this.gallery.isVertical()) {
                return this.gallery.getClientArea().height;
            }
            return this.gallery.getClientArea().width;
        }
        return super.getScrollBarIncrement();
    }

    public boolean isFillIfSingleColumn() {
        return this.fillIfSingleColumn;
    }

    public void setFillIfSingleColumn(boolean fillIfSingle) {
        this.fillIfSingleColumn = fillIfSingle;
    }

    public int getMaxImageWidth() {
        return this.maxImageWidth;
    }

    public void setMaxImageWidth(int imageWidth) {
        this.maxImageWidth = imageWidth;
    }

    public int getMaxImageHeight() {
        return this.maxImageHeight;
    }

    public void setMaxImageHeight(int imageHeight) {
        this.maxImageHeight = imageHeight;
    }

    public boolean isAnimation() {
        return this.animation;
    }

    public void setAnimation(boolean animation) {
        this.animation = animation;
    }

    public int getAnimationLength() {
        return this.animationLength;
    }

    public void setAnimationLength(int animationLength) {
        this.animationLength = animationLength;
    }

    public IMovement getAnimationOpenMovement() {
        return this.animationOpenMovement;
    }

    public IMovement getAnimationCloseMovement() {
        return this.animationCloseMovement;
    }

    public void setAnimationOpenMovement(IMovement animationMovement) {
        this.animationOpenMovement = animationMovement;
    }

    public void setAnimationCloseMovement(IMovement animationMovement) {
        this.animationCloseMovement = animationMovement;
    }

    protected boolean isGroupExpanded(GalleryItem item) {
        if (this.animation && item.getData(DATA_ANIMATION) != null) {
            return true;
        }
        return super.isGroupExpanded(item);
    }

    public boolean isTitleBackgroundGradient() {
        return this.titleBackgroundGradient;
    }

    public Color getTitleBackground2() {
        return this.titleBackground2;
    }
}

