/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.widgets.gallery;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.netxms.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.netxms.nebula.widgets.gallery.GalleryItem;
import org.netxms.nebula.widgets.gallery.RendererHelper;

public class DefaultGalleryItemRenderer
extends AbstractGalleryItemRenderer {
    protected ArrayList dropShadowsColors = new ArrayList();
    boolean dropShadows = false;
    int dropShadowsSize = 0;
    int dropShadowsAlphaStep = 20;
    Color selectionForegroundColor;
    Color selectionBackgroundColor;
    Color foregroundColor = Display.getDefault().getSystemColor(24);
    Color backgroundColor = Display.getDefault().getSystemColor(25);
    boolean showLabels = true;
    boolean showRoundedSelectionCorners = true;
    int selectionRadius = 15;
    private boolean _drawBackground = false;
    private Color _drawBackgroundColor = null;
    private Image _drawImage = null;
    private Color _drawForegroundColor = null;

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public DefaultGalleryItemRenderer() {
        this.selectionForegroundColor = Display.getDefault().getSystemColor(27);
        this.selectionBackgroundColor = Display.getDefault().getSystemColor(26);
        this.createColors();
    }

    public void draw(GC gc, GalleryItem item, int index, int x, int y, int width, int height) {
        this._drawImage = item.getImage();
        this._drawForegroundColor = this.getForeground(item);
        gc.setFont(this.getFont(item));
        int useableHeight = height;
        int fontHeight = 0;
        if (item.getText() != null && !"".equals(item.getText()) && this.showLabels) {
            fontHeight = gc.getFontMetrics().getHeight();
            useableHeight -= fontHeight + 2;
        }
        int imageWidth = 0;
        int imageHeight = 0;
        int xShift = 0;
        int yShift = 0;
        Point size = null;
        if (this._drawImage != null) {
            Rectangle itemImageBounds = this._drawImage.getBounds();
            imageWidth = itemImageBounds.width;
            imageHeight = itemImageBounds.height;
            size = RendererHelper.getBestSize(imageWidth, imageHeight, width - 8 - 2 * this.dropShadowsSize, useableHeight - 8 - 2 * this.dropShadowsSize);
            xShift = RendererHelper.getShift(width, size.x);
            yShift = RendererHelper.getShift(useableHeight, size.y);
            if (this.dropShadows) {
                Color c = null;
                int i = this.dropShadowsSize - 1;
                while (i >= 0) {
                    c = (Color)this.dropShadowsColors.get(i);
                    gc.setForeground(c);
                    gc.drawLine(x + width + i - xShift - 1, y + this.dropShadowsSize + yShift, x + width + i - xShift - 1, y + useableHeight + i - yShift);
                    gc.drawLine(x + xShift + this.dropShadowsSize, y + useableHeight + i - yShift - 1, x + width + i - xShift, y - 1 + useableHeight + i - yShift);
                    --i;
                }
            }
        }
        this._drawBackground = this.selected;
        this._drawBackgroundColor = null;
        if (!this._drawBackground && item.getBackground(true) != null) {
            this._drawBackgroundColor = this.getBackground(item);
            if (!RendererHelper.isColorsEquals(this._drawBackgroundColor, this.galleryBackgroundColor)) {
                this._drawBackground = true;
            }
        }
        if (this._drawBackground) {
            if (this.selected) {
                gc.setBackground(this.selectionBackgroundColor);
                gc.setForeground(this.selectionBackgroundColor);
            } else if (this._drawBackgroundColor != null) {
                gc.setBackground(this._drawBackgroundColor);
            }
            if (this.showRoundedSelectionCorners) {
                gc.fillRoundRectangle(x, y, width, useableHeight, this.selectionRadius, this.selectionRadius);
            } else {
                gc.fillRectangle(x, y, width, height);
            }
            if (item.getText() != null && !"".equals(item.getText()) && this.showLabels) {
                gc.fillRoundRectangle(x, y + height - fontHeight, width, fontHeight, this.selectionRadius, this.selectionRadius);
            }
        }
        if (this._drawImage != null && size != null && size.x > 0 && size.y > 0) {
            gc.drawImage(this._drawImage, 0, 0, imageWidth, imageHeight, x + xShift, y + yShift, size.x, size.y);
            this.drawAllOverlays(gc, item, x, y, size, xShift, yShift);
        }
        if (item.getText() != null && !"".equals(item.getText()) && this.showLabels) {
            if (this.selected) {
                gc.setForeground(this.selectionForegroundColor);
                gc.setBackground(this.selectionBackgroundColor);
            } else {
                if (this._drawBackgroundColor != null) {
                    gc.setBackground(this._drawBackgroundColor);
                } else {
                    gc.setBackground(this.backgroundColor);
                }
                if (this._drawForegroundColor != null) {
                    gc.setForeground(this._drawForegroundColor);
                } else {
                    gc.setForeground(this.foregroundColor);
                }
            }
            String text = RendererHelper.createLabel(item.getText(), gc, width - 10);
            int textWidth = gc.textExtent((String)text).x;
            int textxShift = RendererHelper.getShift(width, textWidth);
            gc.drawText(text, x + textxShift, y + height - fontHeight, true);
        }
    }

    public void setDropShadowsSize(int dropShadowsSize) {
        this.dropShadowsSize = dropShadowsSize;
        this.dropShadowsAlphaStep = dropShadowsSize == 0 ? 0 : 200 / dropShadowsSize;
        this.freeDropShadowsColors();
        this.createColors();
    }

    private void createColors() {
        if (this.dropShadowsSize > 0) {
            int step = 125 / this.dropShadowsSize;
            int i = this.dropShadowsSize - 1;
            while (i >= 0) {
                int value = 255 - i * step;
                Color c = new Color((Device)Display.getDefault(), value, value, value);
                this.dropShadowsColors.add(c);
                --i;
            }
        }
    }

    private void freeDropShadowsColors() {
        Iterator i = this.dropShadowsColors.iterator();
        while (i.hasNext()) {
            Color c = (Color)i.next();
            if (c == null || c.isDisposed()) continue;
            c.dispose();
        }
    }

    public boolean isDropShadows() {
        return this.dropShadows;
    }

    public void setDropShadows(boolean dropShadows) {
        this.dropShadows = dropShadows;
    }

    public int getDropShadowsSize() {
        return this.dropShadowsSize;
    }

    public Font getFont() {
        if (this.gallery != null) {
            return this.gallery.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        if (this.gallery != null) {
            this.gallery.setFont(font);
        }
    }

    public void dispose() {
        this.freeDropShadowsColors();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    public void setSelectionForegroundColor(Color selectionForegroundColor) {
        this.selectionForegroundColor = selectionForegroundColor;
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        this.selectionBackgroundColor = selectionBackgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isShowRoundedSelectionCorners() {
        return this.showRoundedSelectionCorners;
    }

    public void setShowRoundedSelectionCorners(boolean showRoundedSelectionCorners) {
        this.showRoundedSelectionCorners = showRoundedSelectionCorners;
    }
}

