/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class CreateNetworkMapDialog
extends Dialog {
    private Text textName;
    private Combo mapType;
    private ObjectSelector seedObjectSelector;
    private String name;
    private int type;
    private long seedObject;

    public CreateNetworkMapDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Network Map");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Name", (String)"", (Object)"WidgetHelper::default_layout_data");
        this.textName.getShell().setMinimumSize(300, 0);
        this.mapType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Map type", (Object)"WidgetHelper::default_layout_data");
        this.mapType.add("Custom");
        this.mapType.add("IP Topology");
        this.mapType.add("Layer 2 Topology");
        this.mapType.select(0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.mapType.getParent().setLayoutData((Object)gd);
        this.mapType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateNetworkMapDialog.this.seedObjectSelector.setEnabled(CreateNetworkMapDialog.this.mapType.getSelectionIndex() > 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.seedObjectSelector = new ObjectSelector(dialogArea, 0);
        this.seedObjectSelector.setLabel("Seed node");
        this.seedObjectSelector.setObjectClass(2);
        this.seedObjectSelector.setEnabled(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.seedObjectSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.textName.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter non-empty object name");
            return;
        }
        this.type = this.mapType.getSelectionIndex();
        if (this.type > 0) {
            this.seedObject = this.seedObjectSelector.getObjectId();
            if (this.seedObject == 0L) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select seed node");
                return;
            }
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getSeedObject() {
        return this.seedObject;
    }
}

