/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;

public class ObjectFigureSmallLabel
extends ObjectFigure {
    private static final int BORDER_WIDTH = 2;
    private static final int MARGIN_WIDTH = 4;
    private static final int MARGIN_HEIGHT = 2;
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 255, 255, 255);
    private Label label;

    public ObjectFigureSmallLabel(NetworkMapObject element, MapLabelProvider labelProvider) {
        super(element, labelProvider);
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.label = new Label(this.object.getObjectName());
        this.label.setFont(labelProvider.getLabelFont());
        this.label.setLabelAlignment(2);
        this.label.setIcon(labelProvider.getWorkbenchIcon(this.object));
        this.add((IFigure)this.label, BorderLayout.CENTER);
        this.setOpaque(true);
        this.setBackgroundColor(BACKGROUND_COLOR);
        this.updateSize();
    }

    private void updateSize() {
        Dimension ls = this.label.getPreferredSize(-1, -1);
        this.setSize(ls.width + 8 + 4, ls.height + 4 + 4);
    }

    @Override
    protected void onObjectUpdate() {
        this.label.setText(this.object.getObjectName());
        this.label.setIcon(this.labelProvider.getWorkbenchIcon(this.object));
        this.updateSize();
    }

    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        gc.setBackgroundColor(BACKGROUND_COLOR);
        gc.setForegroundColor(StatusDisplayInfo.getStatusColor((int)this.object.getStatus()));
        Rectangle rect = new Rectangle(this.getBounds());
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        gc.setLineWidth(2);
        gc.fillRoundRectangle(rect, 8, 8);
        gc.drawRoundRectangle(rect, 8, 8);
    }
}

