/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.animation.effects;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.netxms.nebula.animation.AnimationRunner;
import org.netxms.nebula.animation.effects.AbstractEffect;
import org.netxms.nebula.animation.movement.IMovement;

public class ResizeEffect
extends AbstractEffect {
    Point src;
    Point dest;
    Point diff;
    Control control = null;

    public static void resize(AnimationRunner runner, Control w, int x, int y, int duration, IMovement movement, Runnable onStop, Runnable onCancel) {
        Point oldSize = w.getSize();
        ResizeEffect effect = new ResizeEffect(w, oldSize, new Point(x, y), duration, movement, onStop, onCancel);
        runner.runEffect(effect);
    }

    public ResizeEffect(Control control, Point src, Point dest, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.src = src;
        this.dest = dest;
        this.diff = new Point(dest.x - src.x, dest.y - src.y);
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
        this.control = control;
    }

    public void applyEffect(long currentTime) {
        if (!this.control.isDisposed()) {
            this.control.setSize((int)((double)this.src.x + (double)this.diff.x * this.easingFunction.getValue((int)currentTime)), (int)((double)this.src.y + (double)this.diff.y * this.easingFunction.getValue((int)currentTime)));
        }
    }
}

