/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.animation.effects;

import org.netxms.nebula.animation.effects.IEffect;

public class SequenceEffect
implements IEffect {
    int currentEffect = 0;
    IEffect[] effects = null;
    long length = 0L;
    Runnable onCancel;
    Runnable onStop;
    long start = 0L;

    public SequenceEffect(IEffect[] effects, Runnable onStop, Runnable onCancel) {
        this.effects = effects;
        this.onCancel = onCancel;
        this.onStop = onStop;
        if (effects != null) {
            IEffect e = null;
            int i = effects.length - 1;
            while (i >= 0) {
                e = effects[i];
                this.length += e.getLength();
                --i;
            }
        }
    }

    public void cancel() {
        int i = this.currentEffect;
        while (i < this.effects.length) {
            this.effects[this.currentEffect].cancel();
            ++i;
        }
        if (this.onCancel != null) {
            this.onCancel.run();
        }
    }

    public void doEffect(long time) {
        if (this.currentEffect >= this.effects.length) {
            return;
        }
        this.effects[this.currentEffect].doEffect(time - this.start);
        if (this.effects[this.currentEffect].isDone()) {
            this.start += this.effects[this.currentEffect].getLength();
            ++this.currentEffect;
        }
        if (this.onStop != null && this.isDone()) {
            this.onStop.run();
        }
    }

    public long getLength() {
        return this.length;
    }

    public boolean isDone() {
        if (this.effects == null) {
            return true;
        }
        return this.effects[this.effects.length - 1].isDone();
    }
}

