/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.animation.effects;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.netxms.nebula.animation.AnimationRunner;
import org.netxms.nebula.animation.effects.AbstractEffect;
import org.netxms.nebula.animation.movement.IMovement;

public class ShakeEffect
extends AbstractEffect {
    Point src;
    Point dest;
    Point diff;
    Control control = null;

    public static void shake(AnimationRunner runner, Control w, int duration, IMovement movement, Runnable onStop, Runnable onCancel) {
        ShakeEffect effect = new ShakeEffect(w, w.getLocation(), new Point(w.getLocation().x + 10, w.getLocation().y + 10), duration, movement, onStop, onCancel);
        runner.runEffect(effect);
    }

    public ShakeEffect(Control control, Point src, Point dest, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.src = src;
        this.dest = dest;
        this.control = control;
        this.diff = new Point(dest.x - src.x, dest.y - src.y);
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
    }

    public void applyEffect(long currentTime) {
        if (!this.control.isDisposed()) {
            this.control.setLocation((int)((double)this.src.x - (double)this.diff.x * this.easingFunction.getValue(currentTime)), this.src.y);
        }
    }
}

