/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets.internal;

import java.util.Iterator;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;

public class ObjectTreeContentProvider
extends TreeNodeContentProvider {
    private NXCSession session = null;
    private long[] rootObjects;

    public ObjectTreeContentProvider(long[] rootObjects) {
        this.rootObjects = rootObjects;
    }

    public Object[] getChildren(Object parentElement) {
        return ((GenericObject)parentElement).getChildsAsArray();
    }

    public Object[] getElements(Object inputElement) {
        if (this.session != null) {
            return this.rootObjects != null ? this.session.findMultipleObjects(this.rootObjects).toArray() : this.session.getTopLevelObjects();
        }
        return new GenericObject[0];
    }

    public Object getParent(Object element) {
        if (this.session == null) {
            return null;
        }
        Iterator it = ((GenericObject)element).getParents();
        return it.hasNext() ? this.session.findObjectById(((Long)it.next()).longValue()) : null;
    }

    public boolean hasChildren(Object element) {
        return ((GenericObject)element).getNumberOfChilds() > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.session = (NXCSession)newInput;
        viewer.refresh();
    }
}

