/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.dashboard.widgets.BarChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.CustomWidgetElement;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.EmbeddedDashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.GeoMapElement;
import org.netxms.ui.eclipse.dashboard.widgets.LabelElement;
import org.netxms.ui.eclipse.dashboard.widgets.LineChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.NetworkMapElement;
import org.netxms.ui.eclipse.dashboard.widgets.ObjectStatusChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.PieChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.StatusIndicatorElement;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;

public class DashboardControl
extends Composite {
    private Dashboard dashboard;
    private boolean embedded = false;

    public DashboardControl(Composite parent, int style, Dashboard dashboard, boolean embedded) {
        super(parent, style);
        this.dashboard = dashboard;
        this.embedded = embedded;
        this.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        this.createContent();
    }

    private void createContent() {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.dashboard.getNumColumns();
        layout.marginWidth = this.embedded ? 0 : 15;
        layout.marginHeight = this.embedded ? 0 : 15;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.setLayout((Layout)layout);
        for (DashboardElement e : this.dashboard.getElements()) {
            ElementWidget w = this.createElementWidget(e);
            DashboardElementLayout el = w.getElementLayout();
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = el.horizontalAlignment == 0;
            gd.horizontalAlignment = DashboardControl.mapHorizontalAlignment(el.horizontalAlignment);
            gd.grabExcessVerticalSpace = el.vertcalAlignment == 0;
            gd.verticalAlignment = DashboardControl.mapVerticalAlignment(el.vertcalAlignment);
            gd.horizontalSpan = el.horizontalSpan;
            gd.verticalSpan = el.verticalSpan;
            w.setLayoutData(gd);
        }
    }

    static int mapHorizontalAlignment(int a) {
        switch (a) {
            case 0: {
                return 4;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 131072;
            }
            case 1: {
                return 0x1000000;
            }
        }
        return 0;
    }

    static int mapVerticalAlignment(int a) {
        switch (a) {
            case 0: {
                return 4;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 1024;
            }
            case 1: {
                return 0x1000000;
            }
        }
        return 0;
    }

    private ElementWidget createElementWidget(DashboardElement e) {
        switch (e.getType()) {
            case 1: {
                return new LineChartElement(this, e.getData(), e.getLayout());
            }
            case 2: {
                return new BarChartElement(this, e.getData(), e.getLayout());
            }
            case 3: {
                return new PieChartElement(this, e.getData(), e.getLayout());
            }
            case 5: {
                return new ObjectStatusChartElement(this, e.getData(), e.getLayout());
            }
            case 0: {
                return new LabelElement(this, e.getData(), e.getLayout());
            }
            case 7: {
                return new EmbeddedDashboardElement(this, e.getData(), e.getLayout());
            }
            case 8: {
                return new NetworkMapElement(this, e.getData(), e.getLayout());
            }
            case 10: {
                return new GeoMapElement(this, e.getData(), e.getLayout());
            }
            case 6: {
                return new StatusIndicatorElement(this, e.getData(), e.getLayout());
            }
            case 9: {
                return new CustomWidgetElement(this, e.getData(), e.getLayout());
            }
        }
        return new ElementWidget(this, e.getData(), e.getLayout());
    }
}

