/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.api.client.Session;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class Authentication
extends PropertyPage {
    private Session session = ConsoleSharedData.getSession();
    private User object;
    private Button checkDisabled;
    private Button checkChangePassword;
    private Button checkFixedPassword;
    private Combo comboAuthMethod;
    private Combo comboMappingMethod;
    private Text textMappingData;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (User)this.getElement().getAdapter(AbstractUserObject.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Group groupFlags = new Group(dialogArea, 0);
        groupFlags.setText("Account Options");
        GridLayout groupFlagsLayout = new GridLayout();
        groupFlags.setLayout((Layout)groupFlagsLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupFlags.setLayoutData((Object)gridData);
        this.checkDisabled = new Button((Composite)groupFlags, 32);
        this.checkDisabled.setText("Account &disabled");
        this.checkDisabled.setSelection(this.object.isDisabled());
        this.checkChangePassword = new Button((Composite)groupFlags, 32);
        this.checkChangePassword.setText("User must &change password at next logon");
        this.checkChangePassword.setSelection(this.object.isPasswordChangeNeeded());
        this.checkFixedPassword = new Button((Composite)groupFlags, 32);
        this.checkFixedPassword.setText("User cannot change &password");
        this.checkFixedPassword.setSelection(this.object.isPasswordChangeForbidden());
        Group groupMethod = new Group(dialogArea, 0);
        groupMethod.setText("Authentication Method");
        GridLayout groupMethodLayout = new GridLayout();
        groupMethodLayout.numColumns = 2;
        groupMethod.setLayout((Layout)groupMethodLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupMethod.setLayoutData((Object)gridData);
        Label label = new Label((Composite)groupMethod, 0);
        label.setText("Authentication method:");
        this.comboAuthMethod = new Combo((Composite)groupMethod, 12);
        this.comboAuthMethod.add("NetXMS password");
        this.comboAuthMethod.add("RADIUS");
        this.comboAuthMethod.add("Certificate");
        this.comboAuthMethod.add("Certificate or Password");
        this.comboAuthMethod.add("Certificate or RADIUS");
        this.comboAuthMethod.select(this.object.getAuthMethod());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboAuthMethod.setLayoutData((Object)gridData);
        label = new Label((Composite)groupMethod, 0);
        label.setText("Certificate mapping method:");
        this.comboMappingMethod = new Combo((Composite)groupMethod, 12);
        this.comboMappingMethod.add("Subject");
        this.comboMappingMethod.add("Public key");
        this.comboMappingMethod.select(this.object.getCertMappingMethod());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboMappingMethod.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.textMappingData = WidgetHelper.createLabeledText((Composite)groupMethod, (int)2052, (int)-1, (String)"Certificate mapping data", (String)this.object.getCertMappingData(), (Object)gridData);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        int flags = 0;
        if (this.checkDisabled.getSelection()) {
            flags |= 4;
        }
        if (this.checkChangePassword.getSelection()) {
            flags |= 8;
        }
        if (this.checkFixedPassword.getSelection()) {
            flags |= 0x10;
        }
        this.object.setFlags(flags);
        this.object.setAuthMethod(this.comboAuthMethod.getSelectionIndex());
        this.object.setCertMappingMethod(this.comboMappingMethod.getSelectionIndex());
        this.object.setCertMappingData(this.textMappingData.getText());
        if (isApply) {
            this.setValid(false);
        }
        new Job("Update user database object"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                try {
                    ((UserManager)Authentication.this.session).modifyUserDBObject((AbstractUserObject)Authentication.this.object, 200);
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.usermanager", e instanceof NetXMSClientException ? ((NetXMSClientException)e).getErrorCode() : 0, "Cannot update user account: " + e.getMessage(), null);
                }
                if (isApply) {
                    new UIJob("Update \"Authentication\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Authentication.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return status;
            }
        }.schedule();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

