/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectToolsCache {
    private static Map<Long, ObjectTool> objectTools = new HashMap<Long, ObjectTool>();
    private static NXCSession session = null;

    public static void init() {
        session = (NXCSession)ConsoleSharedData.getSession();
        ObjectToolsCache.reload();
        session.addListener((SessionListener)new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1009: {
                        ObjectToolsCache.onObjectToolChange(n.getSubCode());
                        break;
                    }
                    case 1015: {
                        ObjectToolsCache.onObjectToolDelete(n.getSubCode());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reload() {
        try {
            List list = session.getObjectTools();
            Map<Long, ObjectTool> map = objectTools;
            synchronized (map) {
                objectTools.clear();
                for (ObjectTool tool : list) {
                    objectTools.put(tool.getId(), tool);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onObjectToolChange(long toolId) {
        Job job = new Job("Update object tools cache"){

            protected IStatus run(IProgressMonitor monitor) {
                ObjectToolsCache.reload();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onObjectToolDelete(long toolId) {
        Map<Long, ObjectTool> map = objectTools;
        synchronized (map) {
            objectTools.remove(toolId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTool[] getTools() {
        ObjectTool[] tools = null;
        Map<Long, ObjectTool> map = objectTools;
        synchronized (map) {
            tools = objectTools.values().toArray(new ObjectTool[objectTools.values().size()]);
        }
        return tools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTool findTool(long toolId) {
        ObjectTool tool;
        Map<Long, ObjectTool> map = objectTools;
        synchronized (map) {
            tool = objectTools.get(toolId);
        }
        return tool;
    }
}

