/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Node;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.views.TableToolResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectToolsDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public ObjectToolsDynamicMenu() {
    }

    public ObjectToolsDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void dispose() {
        super.dispose();
    }

    public void fill(Menu menu, int index) {
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        if (((IStructuredSelection)selection).size() != 1 || !(((IStructuredSelection)selection).getFirstElement() instanceof Node)) {
            return;
        }
        final Node node = (Node)((IStructuredSelection)selection).getFirstElement();
        Menu toolsMenu = new Menu(menu);
        ObjectTool[] tools = ObjectToolsCache.getTools();
        Arrays.sort(tools, new Comparator<ObjectTool>(){

            @Override
            public int compare(ObjectTool arg0, ObjectTool arg1) {
                return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
            }
        });
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        int added = 0;
        int i = 0;
        while (i < tools.length) {
            if (tools[i].isApplicableForNode(node)) {
                String[] path = tools[i].getName().split("\\-\\>");
                Menu rootMenu = toolsMenu;
                int j = 0;
                while (j < path.length - 1) {
                    String key = path[j].replace("&", "");
                    Menu currMenu = (Menu)menus.get(key);
                    if (currMenu == null) {
                        currMenu = new Menu(rootMenu);
                        MenuItem item = new MenuItem(rootMenu, 64);
                        item.setText(path[j]);
                        item.setMenu(currMenu);
                        menus.put(key, currMenu);
                    }
                    rootMenu = currMenu;
                    ++j;
                }
                final MenuItem item = new MenuItem(rootMenu, 8);
                item.setText(path[path.length - 1]);
                item.setData((Object)tools[i]);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ObjectToolsDynamicMenu.this.executeObjectTool(node, (ObjectTool)item.getData());
                    }
                });
                ++added;
            }
            ++i;
        }
        if (added > 0) {
            MenuItem toolsMenuItem = new MenuItem(menu, 64, index);
            toolsMenuItem.setText("&Tools");
            toolsMenuItem.setMenu(toolsMenu);
        } else {
            toolsMenu.dispose();
        }
    }

    private void executeObjectTool(Node node, ObjectTool tool) {
        switch (tool.getType()) {
            case 5: {
                this.executeLocalCommand(node, tool);
                break;
            }
            case 1: {
                this.executeAgentAction(node, tool);
                break;
            }
            case 2: 
            case 3: {
                this.executeTableTool(node, tool);
                break;
            }
        }
    }

    private void executeTableTool(Node node, ObjectTool tool) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page = window.getActivePage();
            TableToolResults view = (TableToolResults)page.showView("org.netxms.ui.eclipse.objecttools.views.TableToolResults", String.valueOf(Long.toString(tool.getId())) + "&" + Long.toString(node.getObjectId()), 1);
            view.refreshTable();
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Error opening view: " + e.getMessage()));
        }
    }

    private void executeAgentAction(final Node node, final ObjectTool tool) {
        new ConsoleJob("Execute action on node " + node.getObjectName(), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                return "Cannot execute action on node " + node.getObjectName();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                session.executeAction(node.getObjectId(), tool.getData());
                new UIJob("Notify user about action execution"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog.openInformation(null, (String)"Tool Execution", (String)("Action " + tool.getData() + " executed successfully on node " + node.getObjectName()));
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }.start();
    }

    private void executeLocalCommand(Node node, ObjectTool tool) {
        String temp = tool.getData();
        temp = temp.replace("%OBJECT_IP_ADDR%", node.getPrimaryIP().getHostAddress());
        temp = temp.replace("%OBJECT_NAME%", node.getObjectName());
        final String command = temp.replace("%OBJECT_ID%", Long.toString(node.getObjectId()));
        IOConsole console = new IOConsole(command, Activator.getImageDescriptor("icons/console.png"));
        IViewPart consoleView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.console.ConsoleView");
        System.out.println("Console view is " + consoleView);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
        final IOConsoleOutputStream out = console.newOutputStream();
        ConsoleJob job = new ConsoleJob("Execute external command", null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                return "Cannot execute external command";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Process proc = Runtime.getRuntime().exec(command);
                BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        out.write(line);
                        out.write("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        job.setUser(false);
        job.start();
    }
}

