/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectmanager.actions.MultipleObjectAction;

public class DeleteObject
extends MultipleObjectAction {
    @Override
    protected boolean confirm() {
        IStructuredSelection selection = this.getSelection();
        String question = selection.size() == 1 ? "Are you sure you want to delete '" + ((GenericObject)selection.getFirstElement()).getObjectName() + "'?" : "Are you sure you want to delete selected objects?";
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getWindow().getShell(), (String)"Confirm Delete", (String)question);
        return confirmed;
    }

    @Override
    protected String errorPrefix() {
        return "Cannot delete object";
    }

    @Override
    protected String jobDescription() {
        return "Delete object";
    }

    @Override
    protected void runObjectAction(NXCSession session, GenericObject object) throws Exception {
        session.deleteObject(object.getObjectId());
    }
}

