/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class MultipleObjectAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchWindow window;

    protected abstract String jobDescription();

    protected abstract String errorPrefix();

    protected abstract void runObjectAction(NXCSession var1, GenericObject var2) throws Exception;

    protected boolean confirm() {
        return true;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public final void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        if (!this.confirm()) {
            return;
        }
        for (final GenericObject object : this.selection) {
            new Job(String.valueOf(this.jobDescription()) + " " + object.getObjectName() + " [" + object.getObjectId() + "]"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status;
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    try {
                        MultipleObjectAction.this.runObjectAction(session, object);
                        status = Status.OK_STATUS;
                    }
                    catch (NXCException e) {
                        status = new Status(4, "org.netxms.ui.eclipse.objectmanager", e.getErrorCode(), String.valueOf(MultipleObjectAction.this.errorPrefix()) + " " + object.getObjectName() + ": " + e.getMessage(), null);
                    }
                    catch (IOException e) {
                        status = new Status(4, "org.netxms.ui.eclipse.objectmanager", 0, String.valueOf(MultipleObjectAction.this.errorPrefix()) + " " + object.getObjectName() + ": I/O error (" + e.getMessage() + ")", null);
                    }
                    catch (Exception e) {
                        status = new Status(4, "org.netxms.ui.eclipse.objectmanager", 0, String.valueOf(MultipleObjectAction.this.errorPrefix()) + " " + object.getObjectName() + ": EXCEPTION (" + e.getMessage() + ")", null);
                    }
                    return status;
                }
            }.schedule();
        }
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            action.setEnabled(this.selection.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }

    protected IStructuredSelection getSelection() {
        return this.selection;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }
}

