/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class Alarm {
    public static final int STATE_OUTSTANDING = 0;
    public static final int STATE_ACKNOWLEDGED = 1;
    public static final int STATE_TERMINATED = 2;
    public static final int HELPDESK_STATE_IGNORED = 0;
    public static final int HELPDESK_STATE_OPEN = 1;
    public static final int HELPDESK_STATE_CLOSED = 2;
    private long id;
    private int currentSeverity;
    private int originalSeverity;
    private int repeatCount;
    private int state;
    private int ackByUser;
    private int terminateByUser;
    private long sourceEventId;
    private int sourceEventCode;
    private long sourceObjectId;
    private Date creationTime;
    private Date lastChangeTime;
    private String message;
    private String key;
    private int helpdeskState;
    private String helpdeskReference;
    private int timeout;
    private int timeoutEvent;

    public Alarm(NXCPMessage msg) {
        this.id = msg.getVariableAsInt64(93L);
        this.currentSeverity = msg.getVariableAsInteger(244L);
        this.originalSeverity = msg.getVariableAsInteger(245L);
        this.repeatCount = msg.getVariableAsInteger(248L);
        this.state = msg.getVariableAsInteger(243L);
        this.ackByUser = msg.getVariableAsInteger(95L);
        this.terminateByUser = msg.getVariableAsInteger(242L);
        this.sourceEventId = msg.getVariableAsInt64(123L);
        this.sourceEventCode = msg.getVariableAsInteger(24L);
        this.sourceObjectId = msg.getVariableAsInt64(3L);
        this.creationTime = new Date(msg.getVariableAsInt64(240L) * 1000L);
        this.lastChangeTime = new Date(msg.getVariableAsInt64(241L) * 1000L);
        this.message = msg.getVariableAsString(66L);
        this.key = msg.getVariableAsString(64L);
        this.helpdeskState = msg.getVariableAsInteger(246L);
        this.helpdeskReference = msg.getVariableAsString(247L);
        this.timeout = msg.getVariableAsInteger(65L);
        this.timeoutEvent = msg.getVariableAsInteger(283L);
    }

    public long getId() {
        return this.id;
    }

    public int getCurrentSeverity() {
        return this.currentSeverity;
    }

    public int getOriginalSeverity() {
        return this.originalSeverity;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getState() {
        return this.state;
    }

    public int getAckByUser() {
        return this.ackByUser;
    }

    public int getTerminateByUser() {
        return this.terminateByUser;
    }

    public long getSourceEventId() {
        return this.sourceEventId;
    }

    public int getSourceEventCode() {
        return this.sourceEventCode;
    }

    public long getSourceObjectId() {
        return this.sourceObjectId;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastChangeTime() {
        return this.lastChangeTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String getKey() {
        return this.key;
    }

    public int getHelpdeskState() {
        return this.helpdeskState;
    }

    public String getHelpdeskReference() {
        return this.helpdeskReference;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTimeoutEvent() {
        return this.timeoutEvent;
    }
}

