/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectBrowser
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.view.navigation.objectbrowser";
    private ObjectTree objectTree;
    private Action actionShowFilter;
    private Action actionHideUnmanaged;
    private Action actionMoveObject;
    private Action actionRefresh;
    private Action actionProperties;

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        long[] rootObjects = null;
        Object value = ConsoleSharedData.getProperty((String)"ObjectBrowser.rootObjects");
        if (value != null && value instanceof long[]) {
            rootObjects = (long[])value;
        }
        this.objectTree = new ObjectTree(parent, 0, 2, rootObjects, null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.setLayoutData(fd);
        this.createActions();
        this.createMenu();
        this.createToolBar();
        this.createPopupMenu();
        this.objectTree.enableDragSupport();
        this.getSite().setSelectionProvider((ISelectionProvider)this.objectTree.getTreeViewer());
        this.objectTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)ObjectBrowser.this.objectTree.getTreeViewer().getSelection()).size();
                ObjectBrowser.this.actionMoveObject.setEnabled(size == 1);
                ObjectBrowser.this.actionProperties.setEnabled(size == 1);
            }
        });
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ObjectBrowser.this.objectTree.refresh();
            }
        };
        this.actionMoveObject = new Action("&Move to another container"){

            public void run() {
                ObjectBrowser.this.moveObject();
            }
        };
        this.actionHideUnmanaged = new Action("&Hide unmanaged objects", 2){

            public void run() {
            }
        };
        this.actionHideUnmanaged.setChecked(false);
        this.actionShowFilter = new Action("Show &filter", 2){

            public void run() {
                ObjectBrowser.this.objectTree.enableFilter(this.isChecked());
            }
        };
        this.actionShowFilter.setChecked(true);
        this.actionProperties = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionHideUnmanaged);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createToolBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectBrowser.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.objectTree.getTreeControl());
        this.objectTree.getTreeControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        if (this.isValidSelectionForMove()) {
            manager.add((IAction)this.actionMoveObject);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("properties"));
        manager.add((IAction)this.actionProperties);
    }

    public void setFocus() {
        this.objectTree.setFocus();
    }

    public void dispose() {
        super.dispose();
    }

    private boolean isValidSelectionForMove() {
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        if (selection.length != 1) {
            return false;
        }
        if (selection[0].getParentItem() == null) {
            return false;
        }
        Object currentObject = selection[0].getData();
        Object parentObject = selection[0].getParentItem().getData();
        return !(!(currentObject instanceof Node) && !(currentObject instanceof Cluster) && !(currentObject instanceof Subnet) && !(currentObject instanceof Condition) && !(currentObject instanceof Container) || !(parentObject instanceof Container) && !(parentObject instanceof ServiceRoot));
    }

    private void moveObject() {
        if (!this.isValidSelectionForMove()) {
            return;
        }
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        final Object currentObject = selection[0].getData();
        final Object parentObject = selection[0].getParentItem().getData();
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createContainerSelectionFilter());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            final GenericObject target = dlg.getSelectedObjects().get(0);
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob("Moving object " + ((GenericObject)currentObject).getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long objectId = ((GenericObject)currentObject).getObjectId();
                    session.bindObject(target.getObjectId(), objectId);
                    session.unbindObject(((GenericObject)parentObject).getObjectId(), objectId);
                }

                protected String getErrorMessage() {
                    return "Cannot move object " + ((GenericObject)currentObject).getObjectName();
                }
            }.start();
        }
    }
}

