/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class GeneralInfo
extends TableElement {
    public GeneralInfo(Composite parent, GenericObject object) {
        super(parent, object);
    }

    @Override
    protected void fillTable() {
        GenericObject object = this.getObject();
        this.addPair("ID", Long.toString(object.getObjectId()));
        if (object.getGuid() != null) {
            this.addPair("GUID", object.getGuid().toString());
        }
        this.addPair("Class", object.getObjectClassName());
        this.addPair("Status", StatusDisplayInfo.getStatusText((int)object.getStatus()));
        switch (object.getObjectClass()) {
            case 3: {
                Interface iface = (Interface)object;
                this.addPair("Interface Index", Integer.toString(iface.getIfIndex()));
                this.addPair("Interface Type", Integer.toString(iface.getIfType()));
                this.addPair("Description", iface.getDescription());
                this.addPair("MAC Address", iface.getMacAddress().toString());
                if ((iface.getFlags() & 2) != 0) {
                    this.addPair("Slot/Port", String.valueOf(Integer.toString(iface.getSlot())) + "/" + Integer.toString(iface.getPort()));
                }
                if (iface.getPrimaryIP().isAnyLocalAddress()) break;
                if (((NXCSession)ConsoleSharedData.getSession()).isZoningEnabled()) {
                    this.addPair("Zone ID", Long.toString(iface.getZoneId()));
                }
                this.addPair("IP Address", iface.getPrimaryIP().getHostAddress());
                this.addPair("IP Subnet Mask", iface.getSubnetMask().getHostAddress());
                break;
            }
            case 2: {
                Node node = (Node)object;
                if (((NXCSession)ConsoleSharedData.getSession()).isZoningEnabled()) {
                    this.addPair("Zone ID", Long.toString(node.getZoneId()));
                }
                this.addPair("Primary IP Address", node.getPrimaryIP().getHostAddress());
                if (node.hasAgent()) {
                    this.addPair("NetXMS Agent Version", node.getAgentVersion());
                }
                this.addPair("System Description", node.getSystemDescription(), false);
                this.addPair("Platform Name", node.getPlatformName(), false);
                this.addPair("SNMP sysName", node.getSnmpSysName(), false);
                this.addPair("SNMP Object ID", node.getSnmpOID(), false);
                if ((node.getFlags() & 4) != 0) {
                    this.addPair("Bridge Base Address", node.getBridgeBaseAddress().toString());
                }
                this.addPair("Driver", node.getDriverName(), false);
                break;
            }
            case 1: {
                Subnet subnet = (Subnet)object;
                if (!((NXCSession)ConsoleSharedData.getSession()).isZoningEnabled()) break;
                this.addPair("Zone ID", Long.toString(subnet.getZoneId()));
                break;
            }
            case 6: {
                Zone zone = (Zone)object;
                this.addPair("Zone ID", Long.toString(zone.getZoneId()));
                break;
            }
        }
        if (object.getGeolocation().getType() != 0) {
            this.addPair("Location", object.getGeolocation().toString());
        }
    }

    @Override
    protected String getTitle() {
        return "General";
    }
}

