/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.dialogs.TrapConfigurationDialog;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpTrapComparator;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpTrapLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SnmpTrapEditor
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.snmp.views.SnmpTrapEditor";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_TRAP_OID = 1;
    public static final int COLUMN_EVENT = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private static final String TABLE_CONFIG_PREFIX = "SnmpTrapEditor";
    private SortableTableViewer viewer;
    private NXCSession session;
    private RefreshAction actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Map<Long, SnmpTrap> traps = new HashMap<Long, SnmpTrap>();

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{"ID", "SNMP Trap OID", "Event", "Description"};
        int[] columnWidths = new int[]{70, 200, 100, 200};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SnmpTrapLabelProvider());
        this.viewer.setComparator((ViewerComparator)new SnmpTrapComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    SnmpTrapEditor.this.actionEdit.setEnabled(selection.size() == 1);
                    SnmpTrapEditor.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SnmpTrapEditor.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)SnmpTrapEditor.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)SnmpTrapEditor.TABLE_CONFIG_PREFIX);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        this.refreshTrapList();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                SnmpTrapEditor.this.refreshTrapList();
            }
        };
        this.actionNew = new Action(){

            public void run() {
                SnmpTrapEditor.this.createTrap();
            }
        };
        this.actionNew.setText("&New trap mapping...");
        this.actionNew.setImageDescriptor(Activator.getImageDescriptor("icons/new.png"));
        this.actionEdit = new Action(){

            public void run() {
                SnmpTrapEditor.this.editTrap();
            }
        };
        this.actionEdit.setText("&Properties...");
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionDelete = new Action(){

            public void run() {
                SnmpTrapEditor.this.deleteTraps();
            }
        };
        this.actionDelete.setText("&Delete");
        this.actionDelete.setImageDescriptor(Activator.getImageDescriptor("icons/delete.png"));
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SnmpTrapEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEdit);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1016: 
            case 1017: {
                Map<Long, SnmpTrap> map = this.traps;
                synchronized (map) {
                    this.traps.put(n.getSubCode(), (SnmpTrap)n.getObject());
                }
                this.updateTrapList();
                break;
            }
            case 1018: {
                Map<Long, SnmpTrap> map = this.traps;
                synchronized (map) {
                    this.traps.remove(n.getSubCode());
                }
                this.updateTrapList();
            }
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private void refreshTrapList() {
        new ConsoleJob("Load SNMP traps configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected String getErrorMessage() {
                return "Cannot load SNMP traps configuration from server";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List list = SnmpTrapEditor.this.session.getSnmpTrapsConfiguration();
                Map map = SnmpTrapEditor.this.traps;
                synchronized (map) {
                    SnmpTrapEditor.this.traps.clear();
                    for (SnmpTrap t : list) {
                        SnmpTrapEditor.this.traps.put(t.getId(), t);
                    }
                }
                SnmpTrapEditor.this.updateTrapList();
            }
        }.start();
    }

    private void updateTrapList() {
        new UIJob("Update SNMP trap list"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                Map map = SnmpTrapEditor.this.traps;
                synchronized (map) {
                    SnmpTrapEditor.this.viewer.setInput((Object)SnmpTrapEditor.this.traps.values().toArray());
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void deleteTraps() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        final Object[] objects = selection.toArray();
        new ConsoleJob("Delete SNMP trap configuration records", (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected String getErrorMessage() {
                return "Cannot delete SNMP trap configuration record";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    SnmpTrapEditor.this.session.deleteSnmpTrapConfiguration(((SnmpTrap)objects[i]).getId());
                    ++i;
                }
            }
        }.start();
    }

    protected void editTrap() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final SnmpTrap trap = (SnmpTrap)selection.getFirstElement();
        TrapConfigurationDialog dlg = new TrapConfigurationDialog(this.getViewSite().getShell(), trap);
        if (dlg.open() == 0) {
            new ConsoleJob("Modify SNMP trap configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

                protected String getErrorMessage() {
                    return "Cannot modify SNMP trap configuration";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    SnmpTrapEditor.this.session.modifySnmpTrapConfiguration(trap);
                }
            }.start();
        }
    }

    protected void createTrap() {
        final SnmpTrap trap = new SnmpTrap();
        trap.setEventCode(500);
        TrapConfigurationDialog dlg = new TrapConfigurationDialog(this.getViewSite().getShell(), trap);
        if (dlg.open() == 0) {
            new ConsoleJob("Create SNMP trap configuration record", (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

                protected String getErrorMessage() {
                    return "Cannot modify SNMP trap configuration";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    trap.setId(SnmpTrapEditor.this.session.createSnmpTrapConfiguration());
                    SnmpTrapEditor.this.session.modifySnmpTrapConfiguration(trap);
                }
            }.start();
        }
    }
}

