/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SystemRights
extends PropertyPage {
    private UserManager userManager;
    private AbstractUserObject object;
    private Map<Integer, Button> buttons = new HashMap<Integer, Button>();

    protected Control createContents(Composite parent) {
        this.userManager = (UserManager)ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractUserObject)this.getElement().getAdapter(AbstractUserObject.class);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.addCheckbox(dialogArea, 256, "Delete alarms");
        this.addCheckbox(dialogArea, 128, "Configure server actions");
        this.addCheckbox(dialogArea, 32, "Configure event templates");
        this.addCheckbox(dialogArea, 16, "View event templates configuration");
        this.addCheckbox(dialogArea, 8, "Configure situations");
        this.addCheckbox(dialogArea, 64, "Edit event processing policy");
        this.addCheckbox(dialogArea, 4096, "Manage script library");
        this.addCheckbox(dialogArea, 2048, "Configure object tools");
        this.addCheckbox(dialogArea, 4, "Configure SNMP traps");
        this.addCheckbox(dialogArea, 32768, "Manage agent configurations");
        this.addCheckbox(dialogArea, 512, "Manage packages");
        this.addCheckbox(dialogArea, 1024, "View event log");
        this.addCheckbox(dialogArea, 16384, "View audit log");
        this.addCheckbox(dialogArea, 8192, "View SNMP trap log");
        this.addCheckbox(dialogArea, 2, "Edit server configuration variables");
        this.addCheckbox(dialogArea, 0x100000, "Read server files");
        this.addCheckbox(dialogArea, 0x400000, "Manage server files");
        this.addCheckbox(dialogArea, 0x200000, "Access server console");
        this.addCheckbox(dialogArea, 8, "Control user sessions");
        this.addCheckbox(dialogArea, 1, "Manage users");
        this.addCheckbox(dialogArea, 131072, "Send SMS");
        this.addCheckbox(dialogArea, 524288, "Register agents");
        return dialogArea;
    }

    private void addCheckbox(Composite parent, int access, String name) {
        Button b = new Button(parent, 32);
        b.setText(name);
        b.setSelection((this.object.getSystemRights() & access) != 0);
        this.buttons.put(access, b);
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        int systemRights = 0;
        for (Map.Entry<Integer, Button> e : this.buttons.entrySet()) {
            if (!e.getValue().getSelection()) continue;
            systemRights |= e.getKey().intValue();
        }
        this.object.setSystemRights(systemRights);
        new ConsoleJob("Update user database object", null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SystemRights.this.userManager.modifyUserDBObject(SystemRights.this.object, 16);
            }

            protected String getErrorMessage() {
                return "Cannot update user object";
            }

            protected void jobFinalize() {
                if (isApply) {
                    new UIJob("Update \"SystemRights\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            SystemRights.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

