/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class StatusIndicatorView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.charts.views.StatusIndicatorView";
    private Runnable refreshTimer;
    private int autoRefreshInterval = 30000;
    private NXCSession session;
    private List<Element> items = new ArrayList<Element>();
    private boolean updateInProgress;
    private Image imageRed;
    private Image imageGreen;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String id = site.getSecondaryId();
        String[] fields = id.split("&");
        int i = 1;
        while (i < fields.length) {
            String[] subfields = fields[i].split("\\@");
            if (subfields.length == 6) {
                try {
                    long nodeId = Long.parseLong(subfields[0], 10);
                    long dciId = Long.parseLong(subfields[1], 10);
                    String description = URLDecoder.decode(subfields[5], "UTF-8");
                    this.items.add(new Element(nodeId, dciId, description));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.items.size() == 1) {
            Element item = this.items.get(0);
            GenericObject object = this.session.findObjectById(item.nodeId);
            if (object != null) {
                this.setPartName(item.name);
            }
        }
        final Display display = site.getShell().getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                StatusIndicatorView.this.update();
                display.timerExec(StatusIndicatorView.this.autoRefreshInterval, (Runnable)this);
            }
        };
        this.imageRed = Activator.getImageDescriptor("icons/light-red.png").createImage();
        this.imageGreen = Activator.getImageDescriptor("icons/light-green.png").createImage();
    }

    protected void update() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Job job = new Job("Get DCI values"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                try {
                    for (Element item : StatusIndicatorView.this.items) {
                        Threshold[] thresholds = StatusIndicatorView.this.session.getThresholds(item.nodeId, item.dciId);
                        item.thresholdActive = thresholds[0].isActive();
                    }
                    status = Status.OK_STATUS;
                    new UIJob("Update chart"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            for (Element item : StatusIndicatorView.this.items) {
                                item.canvas.redraw();
                            }
                            StatusIndicatorView.this.updateInProgress = false;
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.charts", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot get DCI values: " + e.getMessage(), (Throwable)e);
                    StatusIndicatorView.this.updateInProgress = false;
                }
                return status;
            }

            public boolean belongsTo(Object family) {
                return family == "org.netxms.ui.eclipse.charts";
            }
        };
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        layout.numColumns = 5;
        int i = 0;
        while (i < this.items.size()) {
            Element item = this.items.get(i);
            this.createElement(parent, i, item);
            ++i;
        }
        this.getSite().getShell().getDisplay().timerExec(this.autoRefreshInterval, this.refreshTimer);
        this.update();
    }

    private void createElement(Composite parent, int itemId, final Element item) {
        Canvas drawingCanvas = new Canvas(parent, 0);
        GridData data = new GridData(1808);
        drawingCanvas.setLayoutData((Object)data);
        item.canvas = drawingCanvas;
        drawingCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setAntialias(1);
                Canvas canvas = (Canvas)e.widget;
                Point textExtent = e.gc.textExtent(item.name);
                Rectangle clientArea = canvas.getClientArea();
                e.gc.drawText(item.name, clientArea.width / 2 - textExtent.x / 2, clientArea.height - textExtent.y);
                Image image = item.thresholdActive ? StatusIndicatorView.this.imageRed : StatusIndicatorView.this.imageGreen;
                int x = clientArea.width / 2 - image.getBounds().width / 2;
                int y = clientArea.height / 2 - image.getBounds().height / 2 - textExtent.y / 2;
                e.gc.drawImage(image, x, y);
            }
        });
    }

    public void setFocus() {
    }

    private class Element {
        long nodeId;
        long dciId;
        String name;
        boolean thresholdActive;
        Canvas canvas;

        public Element(long nodeId, long dciId, String name) {
            this.nodeId = nodeId;
            this.dciId = dciId;
            this.name = name;
        }
    }
}

