/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.views.helpers;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.ui.eclipse.charts.views.helpers.GraphFolder;

public class GraphTreeContentProvider
implements ITreeContentProvider {
    private GraphFolder rootFolder;
    private Map<GraphSettings, GraphFolder> parentFolders = new HashMap<GraphSettings, GraphFolder>();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GraphFolder) {
            return ((GraphFolder)parentElement).getChildObjects();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof GraphFolder) {
            return ((GraphFolder)element).getParent();
        }
        return this.parentFolders.get(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof GraphFolder) {
            return ((GraphFolder)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{this.rootFolder};
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.parentFolders.clear();
        this.rootFolder = new GraphFolder("[root]", null);
        List gs = (List)newInput;
        if (gs != null) {
            Collections.sort(gs, new Comparator<GraphSettings>(){

                @Override
                public int compare(GraphSettings arg0, GraphSettings arg1) {
                    return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
                }
            });
            HashMap<String, GraphFolder> folders = new HashMap<String, GraphFolder>();
            int i = 0;
            while (i < gs.size()) {
                String[] path = ((GraphSettings)gs.get(i)).getName().split("\\-\\>");
                GraphFolder root = this.rootFolder;
                int j = 0;
                while (j < path.length - 1) {
                    String key = path[j].replace("&", "");
                    GraphFolder curr = (GraphFolder)folders.get(key);
                    if (curr == null) {
                        curr = new GraphFolder(path[j], root);
                        folders.put(key, curr);
                        root.addFolder(curr);
                    }
                    root = curr;
                    ++j;
                }
                root.addGraph((GraphSettings)gs.get(i));
                this.parentFolders.put((GraphSettings)gs.get(i), root);
                ++i;
            }
        }
    }
}

