/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.datafeed.IDataPointEntry;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.model.attribute.DateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.StringFormatSpecifier;
import org.eclipse.birt.chart.model.data.BigNumberDataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.NumberUtil;

public final class ValueFormatter {
    private static final String sNegativeZero = "-0.";
    private static final String sNumericPattern = "0";

    public static final String format(Object oValue, FormatSpecifier formatSpecifier, ULocale lcl, Object oCachedJavaFormatter) throws ChartException {
        FormatSpecifier fs = formatSpecifier;
        if (oValue == null) {
            return null;
        }
        if (oValue instanceof String && !(fs instanceof StringFormatSpecifier)) {
            return (String)oValue;
        }
        if ((fs = ValueFormatter.resetFormatSpecifier(oValue, fs)) == null) {
            if (oCachedJavaFormatter != null) {
                if (NumberUtil.isBigNumber(oValue)) {
                    return ((DecimalFormat)oCachedJavaFormatter).format(((BigNumber)oValue).getValue());
                }
                if (NumberUtil.isBigDecimal(oValue)) {
                    return ((DecimalFormat)oCachedJavaFormatter).format(oValue);
                }
                if (oValue instanceof Double || oValue instanceof NumberDataElement) {
                    if (oCachedJavaFormatter instanceof DecimalFormat) {
                        double dValue = oValue instanceof Double ? ((Double)oValue).doubleValue() : ((NumberDataElement)oValue).getValue();
                        String sValue = ((DecimalFormat)oCachedJavaFormatter).format(dValue);
                        return ValueFormatter.correctNumber(sValue);
                    }
                } else if (oValue instanceof Calendar || oValue instanceof DateTimeDataElement) {
                    Calendar calendar;
                    Calendar calendar2 = calendar = oValue instanceof Calendar ? (Calendar)oValue : ((DateTimeDataElement)oValue).getValueAsCalendar();
                    if (oCachedJavaFormatter instanceof IDateFormatWrapper) {
                        return ((IDateFormatWrapper)oCachedJavaFormatter).format(calendar.getTime());
                    }
                    if (oCachedJavaFormatter instanceof DateFormat) {
                        return ((DateFormat)oCachedJavaFormatter).format((Object)calendar);
                    }
                    if (oCachedJavaFormatter instanceof DateFormatSpecifier) {
                        return ((DateFormatSpecifier)oCachedJavaFormatter).format(calendar, lcl);
                    }
                } else if (oValue instanceof IDataPointEntry && oCachedJavaFormatter instanceof FormatSpecifier) {
                    return ((IDataPointEntry)oValue).getFormattedString((FormatSpecifier)oCachedJavaFormatter, lcl);
                }
            } else {
                if (NumberUtil.isBigNumber(oValue)) {
                    return NumberUtil.getDefaultBigDecimalFormat(lcl).format(((BigNumber)oValue).getValue());
                }
                if (NumberUtil.isBigDecimal(oValue)) {
                    return NumberUtil.getDefaultBigDecimalFormat(lcl).format(oValue);
                }
                if (oValue instanceof Number) {
                    return NumberFormat.getInstance((ULocale)lcl).format(((Number)oValue).doubleValue());
                }
                if (oValue instanceof NumberDataElement) {
                    return NumberFormat.getInstance((ULocale)lcl).format(((NumberDataElement)oValue).getValue());
                }
                if (oValue instanceof BigNumberDataElement) {
                    return NumberFormat.getInstance((ULocale)lcl).format((Object)((BigNumberDataElement)oValue).getValue());
                }
                if (oValue instanceof Calendar) {
                    return DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)lcl).format(oValue);
                }
                if (oValue instanceof DateTimeDataElement) {
                    return DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)lcl).format((Object)((DateTimeDataElement)oValue).getValueAsCalendar());
                }
                if (oValue instanceof IDataPointEntry) {
                    return ((IDataPointEntry)oValue).getFormattedString(null, lcl);
                }
            }
        } else {
            if (oValue instanceof IDataPointEntry) {
                return ((IDataPointEntry)oValue).getFormattedString(fs, lcl);
            }
            if (NumberFormatSpecifier.class.isInstance(fs)) {
                NumberFormatSpecifier nfs = (NumberFormatSpecifier)fs;
                if (NumberUtil.isBigNumber(oValue)) {
                    return ValueFormatter.correctNumber(nfs.format((Number)((BigNumber)oValue).getValue(), lcl));
                }
                if (NumberUtil.isBigDecimal(oValue)) {
                    return ValueFormatter.correctNumber(nfs.format((Number)oValue, lcl));
                }
                double dValue = ValueFormatter.asPrimitiveDouble(oValue, lcl);
                return ValueFormatter.correctNumber(nfs.format(dValue, lcl));
            }
            if (JavaNumberFormatSpecifier.class.isInstance(fs)) {
                JavaNumberFormatSpecifier nfs = (JavaNumberFormatSpecifier)fs;
                if (NumberUtil.isBigNumber(oValue)) {
                    return ValueFormatter.correctNumber(nfs.format((Number)((BigNumber)oValue).getValue(), lcl));
                }
                if (NumberUtil.isBigDecimal(oValue)) {
                    return ValueFormatter.correctNumber(nfs.format((Number)oValue, lcl));
                }
                double dValue = ValueFormatter.asPrimitiveDouble(oValue, lcl);
                return ValueFormatter.correctNumber(nfs.format(dValue, lcl));
            }
            if (FractionNumberFormatSpecifier.class.isInstance(fs)) {
                FractionNumberFormatSpecifier fnfs = (FractionNumberFormatSpecifier)fs;
                double dValue = ValueFormatter.asPrimitiveDouble(oValue, lcl);
                return ValueFormatter.correctNumber(fnfs.format(dValue, lcl));
            }
            if (DateFormatSpecifier.class.isInstance(fs)) {
                DateFormatSpecifier dfs = (DateFormatSpecifier)fs;
                return dfs.format(ValueFormatter.asCalendar(oValue, lcl), lcl);
            }
            if (JavaDateFormatSpecifier.class.isInstance(fs)) {
                JavaDateFormatSpecifier jdfs = (JavaDateFormatSpecifier)fs;
                return jdfs.format(ValueFormatter.asCalendar(oValue, lcl), lcl);
            }
            if (StringFormatSpecifier.class.isInstance(fs)) {
                StringFormatSpecifier jdfs = (StringFormatSpecifier)fs;
                return jdfs.format(oValue.toString(), lcl);
            }
            if (NumberUtil.isBigNumber(oValue)) {
                return NumberUtil.getDefaultBigDecimalFormat(lcl).format(((BigNumber)oValue).getValue());
            }
            if (NumberUtil.isBigDecimal(oValue)) {
                return NumberUtil.getDefaultBigDecimalFormat(lcl).format(oValue);
            }
            if (oValue instanceof Number) {
                return NumberFormat.getInstance((ULocale)lcl).format(((Number)oValue).doubleValue());
            }
            if (oValue instanceof NumberDataElement) {
                return NumberFormat.getInstance((ULocale)lcl).format(((NumberDataElement)oValue).getValue());
            }
            if (oValue instanceof Calendar) {
                return DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)lcl).format(oValue);
            }
            if (oValue instanceof DateTimeDataElement) {
                return DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)lcl).format((Object)((DateTimeDataElement)oValue).getValueAsCalendar());
            }
        }
        return oValue.toString();
    }

    private static FormatSpecifier resetFormatSpecifier(Object oValue, FormatSpecifier fs) {
        if (oValue instanceof IDataPointEntry) {
            return fs;
        }
        if (fs instanceof DateFormatSpecifier || fs instanceof JavaDateFormatSpecifier ? !(oValue instanceof Calendar) && !(oValue instanceof DateTimeDataElement) : (fs instanceof NumberFormatSpecifier || fs instanceof JavaNumberFormatSpecifier || fs instanceof FractionNumberFormatSpecifier ? !(oValue instanceof Number) && !(oValue instanceof NumberDataElement) && !(oValue instanceof BigNumberDataElement) && !NumberUtil.isBigNumber(oValue) && !NumberUtil.isBigDecimal(oValue) : fs instanceof StringFormatSpecifier && !(oValue instanceof String))) {
            return null;
        }
        return fs;
    }

    private static final double asPrimitiveDouble(Object o, ULocale lcl) throws ChartException {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof NumberDataElement) {
            return ((NumberDataElement)o).getValue();
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.convert.double", new Object[]{o}, Messages.getResourceBundle(lcl));
    }

    private static final Calendar asCalendar(Object o, ULocale lcl) throws ChartException {
        if (o instanceof Calendar) {
            return (Calendar)o;
        }
        if (o instanceof DateTimeDataElement) {
            return ((DateTimeDataElement)o).getValueAsCalendar();
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.convert.calendar", new Object[]{o}, Messages.getResourceBundle(lcl));
    }

    private static final String correctNumber(String sValue) {
        int n = sValue.length() - sNegativeZero.length();
        StringBuffer sb = new StringBuffer(sNegativeZero);
        int i = 0;
        while (i < n) {
            sb.append('0');
            ++i;
        }
        if (sValue.equals(sb.toString())) {
            return sb.substring(1);
        }
        return sValue;
    }

    public static String getNumericPattern(Number num) {
        int iDecimalPosition;
        Number numValue = num;
        if (!NumberUtil.isBigDecimal(num)) {
            if (NumberUtil.isBigNumber(num)) {
                numValue = ((BigNumber)num).getValue();
            } else {
                double value = numValue.doubleValue();
                if (ChartUtil.mathEqual(value, (long)value)) {
                    return sNumericPattern;
                }
            }
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        String sValue = String.valueOf(numValue);
        int iEPosition = sValue.indexOf(dfs.getExponentSeparator());
        if (iEPosition > 0) {
            double dValue = Double.valueOf(sValue.substring(0, iEPosition));
            if (ChartUtil.mathEqual(dValue, Math.round(dValue))) {
                return "0E0";
            }
            sValue = String.valueOf(dValue);
        }
        if ((iDecimalPosition = sValue.indexOf(dfs.getDecimalSeparator())) >= 0) {
            int n = sValue.length();
            int i = n - 1;
            while (i > 0) {
                if (sValue.charAt(i) != '0') break;
                --n;
                --i;
            }
            int iMantissaCount = n - 1 - iDecimalPosition;
            StringBuffer sb = new StringBuffer(sNumericPattern);
            if (iMantissaCount > 0) {
                sb.append('.');
                int i2 = 0;
                while (i2 < iMantissaCount) {
                    sb.append('0');
                    ++i2;
                }
            }
            if (iEPosition > 0) {
                sb.append("E0");
            }
            return sb.toString();
        }
        return sNumericPattern;
    }

    public static String getNumericPattern(double dValue) {
        return ValueFormatter.getNumericPattern((Number)dValue);
    }
}

