/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.base.NXCPMessage;
import org.netxms.client.GeoLocationFormatException;

public class GeoLocation {
    private static final double ROUND_OFF = 1.0E-8;
    public static final int UNSET = 0;
    public static final int MANUAL = 1;
    public static final int GPS = 2;
    private int type;
    private double latitude;
    private double longitude;

    public GeoLocation(NXCPMessage msg) {
        this.type = msg.getVariableAsInteger(342L);
        this.latitude = msg.getVariableAsReal(343L);
        this.longitude = msg.getVariableAsReal(344L);
    }

    public GeoLocation(boolean isGPS) {
        this.type = isGPS ? 2 : 0;
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public GeoLocation(double lat, double lon) {
        this.type = 1;
        this.latitude = lat;
        this.longitude = lon;
    }

    public int getType() {
        return this.type;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    private static int getIntegerDegree(double pos) {
        return (int)(Math.abs(pos) + 1.0E-8);
    }

    private static int getIntegerMinutes(double pos) {
        double d = Math.abs(pos) + 1.0E-8;
        return (int)((d - (double)((int)d)) * 60.0);
    }

    private static double getDecimalSeconds(double pos) {
        double d = Math.abs(pos) * 60.0 + 1.0E-8;
        return (d - (double)((int)d)) * 60.0;
    }

    private static String posToText(double pos, boolean isLat) {
        if (pos < -180.0 || pos > 180.0) {
            return "<invalid>";
        }
        StringBuilder sb = new StringBuilder();
        if (isLat) {
            sb.append(pos < 0.0 ? (char)'S' : 'N');
        } else {
            sb.append(pos < 0.0 ? (char)'W' : 'E');
        }
        sb.append(' ');
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        sb.append(nf.format(GeoLocation.getIntegerDegree(pos)));
        sb.append("\u00b0 ");
        sb.append(nf.format(GeoLocation.getIntegerMinutes(pos)));
        sb.append("' ");
        nf = NumberFormat.getNumberInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setMinimumFractionDigits(3);
        nf.setMaximumFractionDigits(3);
        sb.append(nf.format(GeoLocation.getDecimalSeconds(pos)));
        sb.append('\"');
        return sb.toString();
    }

    public String toString() {
        return GeoLocation.posToText(this.latitude, true) + " " + GeoLocation.posToText(this.longitude, false);
    }

    public String getLatitudeAsString() {
        return GeoLocation.posToText(this.latitude, true);
    }

    public String getLongitudeAsString() {
        return GeoLocation.posToText(this.longitude, false);
    }

    private static double parse(String str, boolean isLat) throws GeoLocationFormatException {
        String in = str.trim();
        try {
            double value = Double.parseDouble(str);
            if (value < -180.0 || value > 180.0) {
                throw new GeoLocationFormatException();
            }
            return value;
        }
        catch (NumberFormatException e) {
            Pattern p = Pattern.compile((isLat ? "([NS]*)" : "([EW]*)") + "\\s*([0-9]+(?:\\.[0-9]+)*)\u00b0?\\s*([0-9]+(?:\\.[0-9]+)*)?\\'?\\s*([0-9]+(?:\\.[0-9]+)*)?\\\"?\\s*" + (isLat ? "([NS]*)" : "([EW]*)"));
            Matcher m = p.matcher(in);
            if (m.matches()) {
                char ch;
                if (m.group(1) != null && !m.group(1).isEmpty()) {
                    ch = m.group(1).charAt(0);
                } else if (m.group(5) != null && !m.group(5).isEmpty()) {
                    ch = m.group(5).charAt(0);
                } else {
                    throw new GeoLocationFormatException();
                }
                int sign = ch == 'N' || ch == 'E' ? 1 : -1;
                try {
                    double deg = Double.parseDouble(m.group(2));
                    double min = m.group(3) != null ? Double.parseDouble(m.group(3)) : 0.0;
                    double sec = m.group(4) != null ? Double.parseDouble(m.group(4)) : 0.0;
                    double value = (double)sign * (deg + min / 60.0 + sec / 3600.0);
                    if (value < -180.0 || value > 180.0) {
                        throw new GeoLocationFormatException();
                    }
                    return value;
                }
                catch (NumberFormatException e2) {
                    throw new GeoLocationFormatException();
                }
            }
            throw new GeoLocationFormatException();
        }
    }

    public static GeoLocation parseGeoLocation(String lat, String lon) throws GeoLocationFormatException {
        double _lat = GeoLocation.parse(lat, true);
        double _lon = GeoLocation.parse(lon, false);
        return new GeoLocation(_lat, _lon);
    }
}

