/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import org.netxms.base.NXCPMessage;

public class NetworkMapLink {
    public static final int NORMAL = 0;
    public static final int VPN = 1;
    private String name;
    private int type;
    private long element1;
    private long element2;
    private String connectorName1;
    private String connectorName2;

    public NetworkMapLink(String name, int type, long element1, long element2, String connectorName1, String connectorName2) {
        this.name = name;
        this.type = type;
        this.element1 = element1;
        this.element2 = element2;
        this.connectorName1 = connectorName1;
        this.connectorName2 = connectorName2;
    }

    public NetworkMapLink(int type, long element1, long element2) {
        this.name = "";
        this.type = type;
        this.element1 = element1;
        this.element2 = element2;
        this.connectorName1 = "";
        this.connectorName2 = "";
    }

    public NetworkMapLink(NXCPMessage msg, long baseId) {
        this.name = msg.getVariableAsString(baseId + 1L);
        this.type = msg.getVariableAsInteger(baseId);
        this.element1 = msg.getVariableAsInt64(baseId + 4L);
        this.element2 = msg.getVariableAsInt64(baseId + 5L);
        this.connectorName1 = msg.getVariableAsString(baseId + 2L);
        this.connectorName2 = msg.getVariableAsString(baseId + 3L);
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariableInt16(baseId, this.type);
        msg.setVariable(baseId + 1L, this.name);
        msg.setVariable(baseId + 2L, this.connectorName1);
        msg.setVariable(baseId + 3L, this.connectorName2);
        msg.setVariableInt32(baseId + 4L, (int)this.element1);
        msg.setVariableInt32(baseId + 5L, (int)this.element2);
    }

    public int getType() {
        return this.type;
    }

    public long getElement1() {
        return this.element1;
    }

    public long getElement2() {
        return this.element2;
    }

    public String getConnectorName1() {
        return this.connectorName1;
    }

    public String getConnectorName2() {
        return this.connectorName2;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (this.isUnnamed()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(this.name);
            sb.append(" (");
        }
        sb.append(this.connectorName1 != null && !this.connectorName1.isEmpty() ? this.connectorName1 : "<noname>");
        sb.append(" - ");
        sb.append(this.connectorName2 != null && !this.connectorName2.isEmpty() ? this.connectorName2 : "<noname>");
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasConnectorName1() {
        return this.connectorName1 != null && !this.connectorName1.isEmpty();
    }

    public boolean hasConnectorName2() {
        return this.connectorName2 != null && !this.connectorName2.isEmpty();
    }

    public boolean isUnnamed() {
        return !(this.name != null && !this.name.isEmpty() || this.connectorName1 != null && !this.connectorName1.isEmpty() || this.connectorName2 != null && !this.connectorName2.isEmpty());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkMapLink) {
            return ((NetworkMapLink)obj).element1 == this.element1 && ((NetworkMapLink)obj).element2 == this.element2;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (int)(this.element1 << 16 | this.element2 & 0xFFFFL);
    }
}

