/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.policymanager.dialogs.SelectInstallTargetDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class InstallPolicy
implements IObjectActionDelegate {
    private Shell shell;
    private GenericObject currentObject;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        final SelectInstallTargetDialog dlg = new SelectInstallTargetDialog(this.shell, this.currentObject.getNumberOfChilds() == 0 ? 1 : 0);
        if (dlg.open() == 0) {
            new ConsoleJob("Deploy agent policy", null, "org.netxms.ui.eclipse.policymanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    GenericObject[] nodeList = dlg.getInstallMode() == 1 ? dlg.getSelectedObjects() : InstallPolicy.this.currentObject.getChildsAsArray();
                    int i = 0;
                    while (i < nodeList.length) {
                        session.deployAgentPolicy(InstallPolicy.this.currentObject.getObjectId(), nodeList[i].getObjectId());
                        ++i;
                    }
                }

                protected String getErrorMessage() {
                    return "Cannot deploy agent policy";
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TreeSelection) {
            this.currentObject = (GenericObject)((TreeSelection)selection).getFirstElement();
            action.setEnabled(this.currentObject instanceof AgentPolicy);
        }
    }
}

