/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class LastValuesWidget
extends Composite {
    public static final String JOB_FAMILY = "LastValuesViewJob";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_VALUE = 2;
    public static final int COLUMN_TIMESTAMP = 3;
    private final ViewPart viewPart;
    private Node node;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private SortableTableViewer dataViewer;
    private LastValuesLabelProvider labelProvider;
    private boolean autoRefreshEnabled = false;
    private int autoRefreshInterval = 30000;
    private Runnable refreshTimer;
    private Action actionUseMultipliers;

    public LastValuesWidget(ViewPart viewPart, Composite parent, int style, Node _node, final String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        this.node = _node;
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (LastValuesWidget.this.isDisposed()) {
                    return;
                }
                LastValuesWidget.this.getDataFromServer();
                LastValuesWidget.this.getDisplay().timerExec(LastValuesWidget.this.autoRefreshInterval, (Runnable)this);
            }
        };
        String[] names = new String[]{"ID", "Description", "Value", "Timestamp"};
        int[] widths = new int[]{70, 250, 150, 100};
        this.dataViewer = new SortableTableViewer((Composite)this, names, widths, 0, 1024, -1);
        this.labelProvider = new LastValuesLabelProvider();
        this.dataViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.dataViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataViewer.setComparator((ViewerComparator)new LastValuesComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
        this.actionUseMultipliers = new Action("Use &multipliers", 2){

            public void run() {
                LastValuesWidget.this.setUseMultipliers(!LastValuesWidget.this.areMultipliersUsed());
            }
        };
        this.createPopupMenu();
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                LastValuesWidget.this.dataViewer.getControl().setBounds(LastValuesWidget.this.getClientArea());
            }
        });
        this.dataViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)LastValuesWidget.this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
                ds.put(String.valueOf(configPrefix) + ".autoRefresh", LastValuesWidget.this.autoRefreshEnabled);
                ds.put(String.valueOf(configPrefix) + ".autoRefreshInterval", LastValuesWidget.this.autoRefreshEnabled);
                ds.put(String.valueOf(configPrefix) + ".useMultipliers", LastValuesWidget.this.labelProvider.areMultipliersUsed());
            }
        });
        this.getDataFromServer();
        try {
            ds.getInt(String.valueOf(configPrefix) + ".autoRefreshInterval");
        }
        catch (NumberFormatException numberFormatException) {}
        this.setAutoRefreshEnabled(ds.getBoolean(String.valueOf(configPrefix) + ".autoRefresh"));
        if (ds.get(String.valueOf(configPrefix) + ".useMultipliers") != null) {
            this.labelProvider.setUseMultipliers(ds.getBoolean(String.valueOf(configPrefix) + ".useMultipliers"));
        } else {
            this.labelProvider.setUseMultipliers(true);
        }
        this.actionUseMultipliers.setChecked(this.areMultipliersUsed());
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LastValuesWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.dataViewer.getControl());
        this.dataViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.dataViewer);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionUseMultipliers);
    }

    private void getDataFromServer() {
        if (this.node == null) {
            this.dataViewer.setInput((Object)new DciValue[0]);
            return;
        }
        ConsoleJob job = new ConsoleJob("Get DCI values for node " + this.node.getObjectName(), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot get DCI values for node " + LastValuesWidget.this.node.getObjectName();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DciValue[] data = LastValuesWidget.this.session.getLastValues(LastValuesWidget.this.node.getObjectId());
                new UIJob("Update last values view"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        LastValuesWidget.this.dataViewer.setInput((Object)data);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setNode(Node _node) {
        this.node = _node;
        this.getDataFromServer();
    }

    public void refresh() {
        this.getDataFromServer();
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public void setAutoRefreshEnabled(boolean autoRefreshEnabled) {
        this.autoRefreshEnabled = autoRefreshEnabled;
        this.getDisplay().timerExec(autoRefreshEnabled ? this.autoRefreshInterval : -1, this.refreshTimer);
    }

    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }

    public boolean areMultipliersUsed() {
        return this.labelProvider != null ? this.labelProvider.areMultipliersUsed() : false;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        if (this.labelProvider != null) {
            this.labelProvider.setUseMultipliers(useMultipliers);
            if (this.dataViewer != null) {
                this.dataViewer.refresh(true);
            }
        }
    }
}

