/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.netxms.api.client.servermanager.ServerManager;
import org.netxms.api.client.servermanager.ServerVariable;
import org.netxms.client.NXCException;
import org.netxms.ui.eclipse.serverconfig.dialogs.VariableEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.ServerConfigurationEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EditVariable
implements IObjectActionDelegate {
    private IWorkbenchPart wbPart;
    private Object[] currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }

    public void run(IAction action) {
        if (this.currentSelection.length == 1) {
            ServerVariable var = (ServerVariable)this.currentSelection[0];
            final VariableEditDialog dlg = new VariableEditDialog(this.wbPart.getSite().getShell(), var.getName(), var.getValue());
            if (dlg.open() == 0) {
                Job job = new Job("Modify configuration variable"){

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus status;
                        try {
                            ((ServerManager)ConsoleSharedData.getSession()).setServerVariable(dlg.getVarName(), dlg.getVarValue());
                            if (EditVariable.this.wbPart instanceof ServerConfigurationEditor) {
                                ((ServerConfigurationEditor)EditVariable.this.wbPart).refreshViewer();
                            }
                            status = Status.OK_STATUS;
                        }
                        catch (Exception e) {
                            status = new Status(4, "org.netxms.ui.eclipse.serverconfig", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot modify configuration variable: " + e.getMessage(), (Throwable)e);
                        }
                        return status;
                    }

                    public boolean belongsTo(Object family) {
                        return family == "ServerConfigJob";
                    }
                };
                IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.wbPart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                siteService.schedule(job, 0L, true);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentSelection = ((IStructuredSelection)selection).toArray();
        }
    }
}

