/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.jface.galleryviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.netxms.nebula.jface.galleryviewer.FlatTreeContentProvider;
import org.netxms.nebula.jface.galleryviewer.GalleryViewerRow;
import org.netxms.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.netxms.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.netxms.nebula.widgets.gallery.Gallery;
import org.netxms.nebula.widgets.gallery.GalleryItem;

public class GalleryTreeViewer
extends AbstractTreeViewer {
    protected Gallery gallery;
    protected boolean preservingSelection;
    private GalleryViewerRow cachedRow;

    public GalleryTreeViewer(Composite parent) {
        this(parent, 2562);
    }

    public GalleryTreeViewer(Composite parent, int style) {
        this.gallery = new Gallery(parent, style);
        this.gallery.setGroupRenderer(new DefaultGalleryGroupRenderer());
        this.gallery.setItemRenderer(new DefaultGalleryItemRenderer());
        super.setAutoExpandLevel(-1);
        this.hookControl((Control)this.gallery);
    }

    public GalleryTreeViewer(Gallery gallery) {
        this.gallery = gallery;
        super.setAutoExpandLevel(-1);
        this.hookControl((Control)gallery);
    }

    protected void addTreeListener(Control control, TreeListener listener) {
        ((Gallery)control).addTreeListener(listener);
    }

    protected Item getChild(Widget widget, int index) {
        if (widget instanceof GalleryItem) {
            return ((GalleryItem)widget).getItem(index);
        }
        if (widget instanceof Gallery) {
            return ((Gallery)widget).getItem(index);
        }
        return null;
    }

    protected Item[] getChildren(Widget widget) {
        if (widget instanceof GalleryItem) {
            return ((GalleryItem)widget).getItems();
        }
        if (widget instanceof Gallery) {
            return ((Gallery)widget).getItems();
        }
        return null;
    }

    protected Widget getColumnViewerOwner(int columnIndex) {
        if (columnIndex == 0) {
            return this.getGallery();
        }
        return null;
    }

    protected boolean getExpanded(Item item) {
        return ((GalleryItem)item).isExpanded();
    }

    protected int getItemCount(Control control) {
        return ((Gallery)control).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((GalleryItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((GalleryItem)item).getItems();
    }

    protected Item getParentItem(Item item) {
        return ((GalleryItem)item).getParentItem();
    }

    protected Item[] getSelection(Control control) {
        Item[] selection = ((Gallery)control).getSelection();
        if (selection == null) {
            return new GalleryItem[0];
        }
        ArrayList<Item> notDisposed = new ArrayList<Item>(selection.length);
        int i = 0;
        while (i < selection.length) {
            if (!selection[i].isDisposed()) {
                notDisposed.add(selection[i]);
            } else {
                System.out.println("GalleryItem was disposed (ignoring)");
            }
            ++i;
        }
        selection = notDisposed.toArray(new GalleryItem[notDisposed.size()]);
        return selection;
    }

    protected Item newItem(Widget parent, int style, int index) {
        GalleryItem item = parent instanceof GalleryItem ? (GalleryItem)this.createNewRowPart(this.getViewerRowFromItem(parent), style, index).getItem() : (GalleryItem)this.createNewRowPart(null, style, index).getItem();
        return item;
    }

    protected void removeAll(Control control) {
        ((Gallery)control).removeAll();
    }

    public void setAutoExpandLevel(int level) {
        throw new UnsupportedOperationException("Gallery must be fully expanded.");
    }

    public void setContentProvider(IContentProvider provider) {
        if (provider instanceof IStructuredContentProvider && !(provider instanceof ITreeContentProvider) && !(provider instanceof ITreePathContentProvider)) {
            super.setContentProvider((IContentProvider)new FlatTreeContentProvider((IStructuredContentProvider)provider));
        } else {
            super.setContentProvider(provider);
        }
    }

    protected void setExpanded(Item item, boolean expand) {
        ((GalleryItem)item).setExpanded(expand);
    }

    protected void setSelection(List items) {
        Item[] current = this.getSelection((Control)this.getGallery());
        if (this.isSameSelection(items, current)) {
            return;
        }
        GalleryItem[] newItems = new GalleryItem[items.size()];
        items.toArray(newItems);
        this.getGallery().setSelection(newItems);
    }

    protected void showItem(Item item) {
        this.gallery.showItem((GalleryItem)item);
    }

    public Control getControl() {
        return this.gallery;
    }

    public Gallery getGallery() {
        return this.gallery;
    }

    protected Item getItemAt(Point point) {
        return this.gallery.getItem(point);
    }

    protected ColumnViewerEditor createViewerEditor() {
        return null;
    }

    public void setChildCount(final Object elementOrTreePath, final int count) {
        this.preservingSelection(new Runnable(){

            public void run() {
                if (GalleryTreeViewer.this.internalIsInputOrEmptyPath(elementOrTreePath)) {
                    GalleryTreeViewer.this.getGallery().setItemCount(count);
                    return;
                }
                Widget[] items = GalleryTreeViewer.this.internalFindItems(elementOrTreePath);
                int i = 0;
                while (i < items.length) {
                    GalleryItem galleryItem = (GalleryItem)items[i];
                    galleryItem.setItemCount(count);
                    ++i;
                }
            }
        });
    }

    protected ViewerRow getViewerRowFromItem(Widget item) {
        if (this.cachedRow == null) {
            this.cachedRow = new GalleryViewerRow((GalleryItem)item);
        } else {
            this.cachedRow.setItem((GalleryItem)item);
        }
        return this.cachedRow;
    }

    private ViewerRow createNewRowPart(ViewerRow parent, int style, int rowIndex) {
        if (parent == null) {
            if (rowIndex >= 0) {
                return this.getViewerRowFromItem((Widget)new GalleryItem(this.gallery, style, rowIndex));
            }
            return this.getViewerRowFromItem((Widget)new GalleryItem(this.gallery, style));
        }
        if (rowIndex >= 0) {
            return this.getViewerRowFromItem((Widget)new GalleryItem((GalleryItem)parent.getItem(), 0, rowIndex));
        }
        return this.getViewerRowFromItem((Widget)new GalleryItem((GalleryItem)parent.getItem(), 0));
    }

    public void remove(final Object parentOrTreePath, final int index) {
        final LinkedList<TreePath> oldSelection = new LinkedList<TreePath>(Arrays.asList(((TreeSelection)this.getSelection()).getPaths()));
        this.preservingSelection(new Runnable(){

            public void run() {
                TreePath removedPath = null;
                if (GalleryTreeViewer.this.internalIsInputOrEmptyPath(parentOrTreePath)) {
                    Gallery gallery = (Gallery)GalleryTreeViewer.this.getControl();
                    if (index < gallery.getItemCount()) {
                        GalleryItem item = gallery.getItem(index);
                        if (item.getData() != null) {
                            removedPath = GalleryTreeViewer.this.getTreePathFromItem(item);
                            GalleryTreeViewer.this.disassociate(item);
                        }
                        item.dispose();
                    }
                } else {
                    Widget[] parentItems = GalleryTreeViewer.this.internalFindItems(parentOrTreePath);
                    int i = 0;
                    while (i < parentItems.length) {
                        GalleryItem parentItem = (GalleryItem)parentItems[i];
                        if (index < parentItem.getItemCount()) {
                            GalleryItem item = parentItem.getItem(index);
                            if (item.getData() != null) {
                                removedPath = GalleryTreeViewer.this.getTreePathFromItem(item);
                                GalleryTreeViewer.this.disassociate(item);
                            }
                            item.dispose();
                        }
                        ++i;
                    }
                }
                if (removedPath != null) {
                    boolean removed = false;
                    Iterator it = oldSelection.iterator();
                    while (it.hasNext()) {
                        TreePath path = (TreePath)it.next();
                        if (!path.startsWith(removedPath, GalleryTreeViewer.this.getComparer())) continue;
                        it.remove();
                        removed = true;
                    }
                    if (removed) {
                        GalleryTreeViewer.this.setSelection((ISelection)new TreeSelection(oldSelection.toArray(new TreePath[oldSelection.size()]), GalleryTreeViewer.this.getComparer()), false);
                    }
                }
            }
        });
    }

    public void editElement(Object element, int column) {
        if (element instanceof TreePath) {
            ViewerCell cell;
            ViewerRow row;
            this.setSelection((ISelection)new TreeSelection((TreePath)element));
            GalleryItem[] items = this.gallery.getSelection();
            if (items.length == 1 && (row = this.getViewerRowFromItem((Widget)items[0])) != null && (cell = row.getCell(column)) != null) {
                this.getControl().setRedraw(false);
                this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell));
                this.getControl().setRedraw(true);
            }
        } else {
            super.editElement(element, column);
        }
    }
}

