/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.base.NXCPMessage;

public class EventProcessingPolicyRule {
    public static final int STOP_PROCESSING = 1;
    public static final int NEGATED_SOURCE = 2;
    public static final int NEGATED_EVENTS = 4;
    public static final int GENERATE_ALARM = 8;
    public static final int DISABLED = 16;
    public static final int TERMINATE_BY_REGEXP = 32;
    public static final int SEVERITY_NORMAL = 256;
    public static final int SEVERITY_WARNING = 512;
    public static final int SEVERITY_MINOR = 1024;
    public static final int SEVERITY_MAJOR = 2048;
    public static final int SEVERITY_CRITICAL = 4096;
    public static final int SEVERITY_ANY = 7936;
    private List<Long> sources;
    private List<Long> events;
    private String script;
    private int flags;
    private String alarmKey;
    private String alarmMessage;
    private int alarmSeverity;
    private int alarmTimeout;
    private long alarmTimeoutEvent;
    private List<Long> actions;
    private long situationId;
    private String situationInstance;
    private Map<String, String> situationAttributes;
    private String comments;

    public EventProcessingPolicyRule() {
        this.sources = new ArrayList<Long>(0);
        this.events = new ArrayList<Long>(0);
        this.script = "";
        this.flags = 7936;
        this.alarmKey = "";
        this.alarmMessage = "%m";
        this.alarmSeverity = 5;
        this.alarmTimeout = 0;
        this.alarmTimeoutEvent = 43L;
        this.actions = new ArrayList<Long>(0);
        this.situationId = 0L;
        this.situationInstance = "";
        this.situationAttributes = new HashMap<String, String>(0);
        this.comments = "";
    }

    public EventProcessingPolicyRule(EventProcessingPolicyRule src) {
        this.sources = new ArrayList<Long>(src.sources);
        this.events = new ArrayList<Long>(src.events);
        this.script = src.script;
        this.flags = src.flags;
        this.alarmKey = src.alarmKey;
        this.alarmMessage = src.alarmMessage;
        this.alarmSeverity = src.alarmSeverity;
        this.alarmTimeout = src.alarmTimeout;
        this.alarmTimeoutEvent = src.alarmTimeoutEvent;
        this.actions = new ArrayList<Long>(src.actions);
        this.situationId = src.situationId;
        this.situationInstance = src.situationInstance;
        this.situationAttributes = new HashMap<String, String>(src.situationAttributes);
        this.comments = src.comments;
    }

    public EventProcessingPolicyRule(NXCPMessage msg) {
        this.sources = Arrays.asList(msg.getVariableAsUInt32ArrayEx(71L));
        this.events = Arrays.asList(msg.getVariableAsUInt32ArrayEx(72L));
        this.script = msg.getVariableAsString(228L);
        this.flags = msg.getVariableAsInteger(13L);
        this.alarmKey = msg.getVariableAsString(64L);
        this.alarmMessage = msg.getVariableAsString(66L);
        this.alarmSeverity = msg.getVariableAsInteger(63L);
        this.alarmTimeout = msg.getVariableAsInteger(65L);
        this.alarmTimeoutEvent = msg.getVariableAsInt64(283L);
        this.actions = Arrays.asList(msg.getVariableAsUInt32ArrayEx(73L));
        this.situationId = msg.getVariableAsInt64(301L);
        this.situationInstance = msg.getVariableAsString(302L);
        this.comments = msg.getVariableAsString(82L);
        int numAttrs = msg.getVariableAsInteger(303L);
        this.situationAttributes = new HashMap<String, String>(numAttrs);
        long varId = 0x10000000L;
        for (int i = 0; i < numAttrs; ++i) {
            String attr = msg.getVariableAsString(varId++);
            String value = msg.getVariableAsString(varId++);
            this.situationAttributes.put(attr, value);
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariableInt32(13L, this.flags);
        msg.setVariable(82L, this.comments);
        msg.setVariable(228L, this.script);
        msg.setVariableInt32(70L, this.actions.size());
        msg.setVariable(73L, this.actions.toArray(new Long[this.actions.size()]));
        msg.setVariableInt32(69L, this.events.size());
        msg.setVariable(72L, this.events.toArray(new Long[this.events.size()]));
        msg.setVariableInt32(68L, this.sources.size());
        msg.setVariable(71L, this.sources.toArray(new Long[this.sources.size()]));
        msg.setVariable(64L, this.alarmKey);
        msg.setVariable(66L, this.alarmMessage);
        msg.setVariableInt16(63L, this.alarmSeverity);
        msg.setVariableInt32(65L, this.alarmTimeout);
        msg.setVariableInt32(283L, (int)this.alarmTimeoutEvent);
        msg.setVariableInt32(301L, (int)this.situationId);
        msg.setVariable(302L, this.situationInstance);
        msg.setVariableInt32(303L, this.situationAttributes.size());
        long varId = 0x10000000L;
        for (Map.Entry<String, String> e : this.situationAttributes.entrySet()) {
            msg.setVariable(varId++, e.getKey());
            msg.setVariable(varId++, e.getValue());
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public void setAlarmKey(String alarmKey) {
        this.alarmKey = alarmKey;
    }

    public String getAlarmMessage() {
        return this.alarmMessage;
    }

    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    public int getAlarmSeverity() {
        return this.alarmSeverity;
    }

    public void setAlarmSeverity(int alarmSeverity) {
        this.alarmSeverity = alarmSeverity;
    }

    public int getAlarmTimeout() {
        return this.alarmTimeout;
    }

    public void setAlarmTimeout(int alarmTimeout) {
        this.alarmTimeout = alarmTimeout;
    }

    public long getAlarmTimeoutEvent() {
        return this.alarmTimeoutEvent;
    }

    public void setAlarmTimeoutEvent(long alarmTimeoutEvent) {
        this.alarmTimeoutEvent = alarmTimeoutEvent;
    }

    public long getSituationId() {
        return this.situationId;
    }

    public void setSituationId(long situationId) {
        this.situationId = situationId;
    }

    public String getSituationInstance() {
        return this.situationInstance;
    }

    public void setSituationInstance(String situationInstance) {
        this.situationInstance = situationInstance;
    }

    public List<Long> getSources() {
        return this.sources;
    }

    public List<Long> getEvents() {
        return this.events;
    }

    public List<Long> getActions() {
        return this.actions;
    }

    public Map<String, String> getSituationAttributes() {
        return this.situationAttributes;
    }

    public void setSources(List<Long> sources) {
        this.sources = sources;
    }

    public void setEvents(List<Long> events) {
        this.events = events;
    }

    public void setActions(List<Long> actions) {
        this.actions = actions;
    }

    public void setSituationAttributes(Map<String, String> situationAttributes) {
        this.situationAttributes = situationAttributes;
    }

    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }
}

