/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.dashboard.dialogs.AddDashboardElementDlg;
import org.netxms.ui.eclipse.dashboard.dialogs.EditElementXmlDlg;
import org.netxms.ui.eclipse.dashboard.propertypages.helpers.DashboardElementsLabelProvider;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DashboardElements
extends PropertyPage {
    public static final int COLUMN_TYPE = 0;
    public static final int COLUMN_SPAN = 1;
    public static final int COLUMN_ALIGNMENT = 2;
    private Dashboard object;
    private LabeledText columnCount;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button editXmlButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<DashboardElement> elements;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Dashboard)this.getElement().getAdapter(Dashboard.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.columnCount = new LabeledText(dialogArea, 0);
        this.columnCount.setLabel("Number of columns");
        this.columnCount.setText(Integer.toString(this.object.getNumColumns()));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.columnCount.setLayoutData((Object)gridData);
        String[] columnNames = new String[]{"Type", "Span", "Alignment"};
        int[] columnWidths = new int[]{150, 60, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DashboardElementsLabelProvider());
        this.elements = DashboardElements.copyElements(this.object.getElements());
        this.viewer.setInput((Object)this.elements.toArray());
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText("&Up");
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.moveUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText("&Down");
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.moveDown();
            }
        });
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText("&Add...");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.addNewElement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.editButton = new Button(rightButtons, 8);
        this.editButton.setText("&Edit...");
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.editElement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.editXmlButton = new Button(rightButtons, 8);
        this.editXmlButton.setText("Edit &XML...");
        this.editXmlButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.editElementXml();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText("&Delete");
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.deleteElements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int index = DashboardElements.this.elements.indexOf(selection.getFirstElement());
                DashboardElements.this.upButton.setEnabled(selection.size() == 1 && index > 0);
                DashboardElements.this.downButton.setEnabled(selection.size() == 1 && index >= 0 && index < DashboardElements.this.elements.size() - 1);
                DashboardElements.this.editButton.setEnabled(selection.size() == 1);
                DashboardElements.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DashboardElements.this.editButton.notifyListeners(13, new Event());
            }
        });
        return dialogArea;
    }

    private static List<DashboardElement> copyElements(List<DashboardElement> src) {
        ArrayList<DashboardElement> dst = new ArrayList<DashboardElement>(src.size());
        for (DashboardElement e : src) {
            dst.add(new DashboardElement(e));
        }
        return dst;
    }

    private boolean applyChanges(final boolean isApply) {
        int numColumns;
        try {
            numColumns = Integer.parseInt(this.columnCount.getText());
            if (numColumns < 1 || numColumns > 8) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please enter valid integer in range 1 .. 8 as number of columns");
            return false;
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setDashboardElements(this.elements);
        md.setColumnCount(numColumns);
        if (isApply) {
            this.setValid(false);
        }
        new ConsoleJob("Update dashboard configuration", null, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ((NXCSession)ConsoleSharedData.getSession()).modifyObject(md);
            }

            protected String getErrorMessage() {
                return "Cannot update dashboard configuration";
            }

            protected void jobFinalize() {
                if (isApply) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DashboardElements.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    private void addNewElement() {
        AddDashboardElementDlg dlg = new AddDashboardElementDlg(this.getShell());
        if (dlg.open() == 0) {
            String config;
            switch (dlg.getElementType()) {
                case 2: 
                case 3: 
                case 4: {
                    config = "<element>\n\t<showIn3D>true</showIn3D>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
                    break;
                }
                case 1: {
                    config = "<element>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
                    break;
                }
                case 12: {
                    config = "<element>\n\t<objectId>9</objectId>\n\t<showIn3D>true</showIn3D>\n</element>";
                    break;
                }
                case 0: {
                    config = "<element>\n\t<title>Label</title>\n</element>";
                    break;
                }
                case 6: 
                case 7: 
                case 11: {
                    config = "<element>\n\t<objectId>0</objectId>\n</element>";
                    break;
                }
                default: {
                    config = "<element></element>";
                }
            }
            DashboardElement element = new DashboardElement(dlg.getElementType(), config);
            this.elements.add(element);
            this.viewer.setInput((Object)this.elements.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    private void editElement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        DashboardElement element = (DashboardElement)selection.getFirstElement();
        DashboardElementConfig config = (DashboardElementConfig)AdapterManager.getDefault().getAdapter((Object)element, DashboardElementConfig.class);
        if (config != null) {
            try {
                config.setLayout(DashboardElementLayout.createFromXml(element.getLayout()));
                PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getShell(), null, (Object)config);
                if (dlg.open() == 1) {
                    return;
                }
                element.setData(config.createXml());
                element.setLayout(config.getLayout().createXml());
                this.viewer.update((Object)element, null);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Internal Error", (String)("Internal error: " + e.getMessage()));
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Internal Error", (String)"Internal error: no adapter for dashboard element");
        }
    }

    private void editElementXml() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        DashboardElement element = (DashboardElement)selection.getFirstElement();
        EditElementXmlDlg dlg = new EditElementXmlDlg(this.getShell(), element.getData());
        if (dlg.open() == 0) {
            element.setData(dlg.getValue());
            this.viewer.update((Object)element, null);
        }
    }

    private void deleteElements() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.elements.remove(o);
        }
        this.viewer.setInput((Object)this.elements.toArray());
    }

    private void moveUp() {
        DashboardElement element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = (DashboardElement)selection.getFirstElement())) > 0) {
            Collections.swap(this.elements, index - 1, index);
            this.viewer.setInput((Object)this.elements.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    private void moveDown() {
        DashboardElement element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = (DashboardElement)selection.getFirstElement())) < this.elements.size() - 1 && index >= 0) {
            Collections.swap(this.elements, index + 1, index);
            this.viewer.setInput((Object)this.elements.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }
}

