/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.Arrays;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.widgets.DataComparisonBirtChart;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardDciInfo;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectStatusChartConfig;

public class ObjectStatusChartElement
extends ComparisonChartElement {
    private ObjectStatusChartConfig config;

    public ObjectStatusChartElement(DashboardControl parent, DashboardElement element) {
        super(parent, element);
        try {
            this.config = ObjectStatusChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new ObjectStatusChartConfig();
        }
        this.chart = new DataComparisonBirtChart((Composite)this, 0, 0);
        this.chart.setTitleVisible(true);
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLegendPosition(this.config.getLegendPosition());
        this.chart.setLegendVisible(this.config.isShowLegend());
        this.chart.set3DModeEnabled(this.config.isShowIn3D());
        this.chart.setTransposed(this.config.isTransposed());
        this.chart.setTranslucent(this.config.isTranslucent());
        int i = 0;
        while (i <= 5) {
            this.chart.addParameter(new GraphItem(0L, 0L, 0, 0, StatusDisplayInfo.getStatusText((int)i), StatusDisplayInfo.getStatusText((int)i)), 0.0);
            this.chart.setPaletteEntry(i, new ChartColor(StatusDisplayInfo.getStatusColor((int)i).getRGB()));
            ++i;
        }
        this.chart.initializationComplete();
        this.startRefreshTimer();
    }

    @Override
    protected DashboardDciInfo[] getDciList() {
        return null;
    }

    @Override
    protected void refreshData(DashboardDciInfo[] dciList) {
        int[] objectCount = new int[6];
        Arrays.fill(objectCount, 0);
        GenericObject root = this.session.findObjectById(this.config.getRootObject());
        if (root != null) {
            this.collectData(objectCount, root);
        }
        int i = 0;
        while (i < objectCount.length) {
            this.chart.updateParameter(i, (double)objectCount[i], false);
            ++i;
        }
        this.chart.refresh();
    }

    private void collectData(int[] objectCount, GenericObject root) {
        GenericObject[] genericObjectArray = root.getChildsAsArray();
        int n = genericObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericObject o = genericObjectArray[n2];
            if (o.getStatus() <= 5 && this.filterObject(o)) {
                int n3 = o.getStatus();
                objectCount[n3] = objectCount[n3] + 1;
            }
            this.collectData(objectCount, o);
            ++n2;
        }
    }

    private boolean filterObject(GenericObject o) {
        int[] cf = this.config.getClassFilter();
        int i = 0;
        while (i < cf.length) {
            if (o.getObjectClass() == cf[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

